/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class MockPredicateTest
extends ContextTestSupport {
    @Test
    public void testMockPredicate() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.message(0).predicate().header("foo");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMockPredicateAsParameter() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.message(0).predicate(PredicateBuilder.isNotNull((Expression)MockPredicateTest.header("foo")));
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:foo");
            }
        };
    }
}

