/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.ArrayList;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class MockExpectedBodiesAsListTest
extends ContextTestSupport {
    @Test
    public void testUsingVarargs() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUsingListString() throws Exception {
        ArrayList<String> data = new ArrayList<String>();
        data.add("Hello World");
        data.add("Bye World");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(data);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUsingList() throws Exception {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add("Hello World");
        data.add(123);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(data);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)123);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

