/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Service;
import org.apache.camel.StatefulService;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MockEndpointTimeClauseTest
extends ContextTestSupport {
    @Test
    public void testReceivedTimestamp() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.message(0).predicate(e -> e.getClock().getCreated() > 0L);
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelReceivedTimestamp")).isNotNull();
        ((MockValueBuilder)mock.message(0).exchangeProperty("CamelReceivedTimestamp")).isInstanceOf(Date.class);
        this.template.sendBody("direct:a", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAssertPeriod() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.setAssertPeriod(10L);
        this.template.sendBody("direct:a", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAssertPeriodNot() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.setAssertPeriod(10L);
        this.template.sendBody("direct:a", (Object)"A");
        this.template.sendBody("direct:a", (Object)"B");
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testAssertPeriodSecondMessageArrives() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.setAssertPeriod(250L);
        this.template.sendBody("direct:a", (Object)"A");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (MockEndpointTimeClauseTest.this.isStarted((Service)MockEndpointTimeClauseTest.this.template)) {
                    MockEndpointTimeClauseTest.this.template.sendBody("direct:a", (Object)"B");
                }
            }
        });
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> ((MockEndpoint)mock).assertIsSatisfied(), (String)"Should have thrown an exception"));
        Assertions.assertEquals((Object)"mock://result Received message count. Expected: <1> but was: <2>", (Object)((Throwable)((Object)e)).getMessage());
        executor.shutdownNow();
    }

    @Test
    public void testNoAssertPeriodSecondMessageArrives() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)"A");
        final CountDownLatch latch = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                    if (MockEndpointTimeClauseTest.this.isStarted((Service)MockEndpointTimeClauseTest.this.template)) {
                        MockEndpointTimeClauseTest.this.template.sendBody("direct:a", (Object)"B");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.assertMockEndpointsSatisfied();
        latch.countDown();
        executor.shutdownNow();
    }

    @Test
    public void testArrivesBeforeNext() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.message(0).arrives().noLaterThan(1).seconds().beforeNext();
        this.template.sendBody("direct:a", (Object)"A");
        Thread.sleep(50L);
        this.template.sendBody("direct:a", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testArrivesAfterPrevious() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.message(1).arrives().noLaterThan(1).seconds().afterPrevious();
        this.template.sendBody("direct:a", (Object)"A");
        Thread.sleep(50L);
        this.template.sendBody("direct:a", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testArrivesBeforeAndAfter() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.message(1).arrives().noLaterThan(250).millis().afterPrevious();
        mock.message(1).arrives().noLaterThan(250).millis().beforeNext();
        this.template.sendBody("direct:a", (Object)"A");
        Thread.sleep(50L);
        this.template.sendBody("direct:a", (Object)"B");
        Thread.sleep(50L);
        this.template.sendBody("direct:a", (Object)"C");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testArrivesWithinAfterPrevious() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.message(1).arrives().between(10, 500).millis().afterPrevious();
        this.template.sendBody("direct:a", (Object)"A");
        Thread.sleep(50L);
        this.template.sendBody("direct:a", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testArrivesWithinBeforeNext() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.message(0).arrives().between(10, 500).millis().beforeNext();
        this.template.sendBody("direct:a", (Object)"A");
        Thread.sleep(50L);
        this.template.sendBody("direct:a", (Object)"B");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testArrivesAllMessages() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(5);
        mock.allMessages().arrives().noLaterThan(1).seconds().beforeNext();
        this.template.sendBody("direct:a", (Object)"A");
        this.template.sendBody("direct:a", (Object)"B");
        Thread.sleep(50L);
        this.template.sendBody("direct:a", (Object)"C");
        Thread.sleep(50L);
        this.template.sendBody("direct:a", (Object)"D");
        Thread.sleep(50L);
        this.template.sendBody("direct:a", (Object)"E");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").to("mock:result");
            }
        };
    }

    private boolean isStarted(Service service) {
        if (service instanceof StatefulService) {
            StatefulService statefulService = (StatefulService)service;
            return statefulService.isStarted();
        }
        return true;
    }
}

