/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MockEndpointTest
extends ContextTestSupport {
    @Test
    public void testAscendingMessagesPass() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsAscending((Expression)MockEndpointTest.header("counter").convertTo(Number.class));
        this.sendMessages(11, 12, 13, 14, 15);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testAscendingMessagesFail() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsAscending((Expression)MockEndpointTest.header("counter").convertTo(Number.class));
        this.sendMessages(11, 12, 13, 15, 14);
        resultEndpoint.assertIsNotSatisfied();
    }

    @Test
    public void testDescendingMessagesPass() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsDescending((Expression)MockEndpointTest.header("counter").convertTo(Number.class));
        this.sendMessages(15, 14, 13, 12, 11);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testDescendingMessagesFail() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsDescending((Expression)MockEndpointTest.header("counter").convertTo(Number.class));
        this.sendMessages(15, 14, 13, 11, 12);
        resultEndpoint.assertIsNotSatisfied();
    }

    @Test
    public void testExpectsBodiesInOrder() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived(this.listOfMessages(11, 12, 13, 14, 15));
        this.sendMessages(11, 12, 13, 14, 15);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testExpectsBodiesInAnyOrder() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceivedInAnyOrder(this.listOfMessages(11, 12, 13, 14, 15));
        this.sendMessages(15, 12, 14, 13, 11);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testExpectsBodiesInAnyOrderWithDuplicates() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceivedInAnyOrder(this.listOfMessages(11, 15, 12, 12, 13, 14, 15, 15));
        this.sendMessages(15, 15, 12, 14, 13, 12, 15, 11);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testExpectsHeadersInAnyOrder() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedHeaderValuesReceivedInAnyOrder("counter", new Object[]{11, 12, 13, 14, 15});
        this.sendMessages(15, 12, 14, 13, 11);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testExpectsHeadersInAnyOrderFail() {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedHeaderValuesReceivedInAnyOrder("counter", new Object[]{11, 12, 7, 14, 15});
        this.sendMessages(15, 12, 14, 13, 11);
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> ((MockEndpoint)resultEndpoint).assertIsSatisfied(), (String)"Should fail"));
        Assertions.assertEquals((Object)"mock://result Expected 5 headers with key[counter], received 4 headers. Expected header values: [7]", (Object)((Throwable)((Object)e)).getMessage());
    }

    @Test
    public void testExpectsPropertiesInAnyOrder() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedPropertyValuesReceivedInAnyOrder("foo", new Object[]{123, 456});
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", (Object)456);
            }
        });
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", (Object)123);
            }
        });
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testExpectsPropertiesInAnyOrderFail() {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedPropertyValuesReceivedInAnyOrder("foo", new Object[]{123, 456});
        this.template.send("direct:a", exchange -> exchange.setProperty("foo", (Object)123));
        this.template.send("direct:a", exchange -> exchange.setProperty("foo", (Object)789));
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> ((MockEndpoint)resultEndpoint).assertIsSatisfied(), (String)"Should fail"));
        Assertions.assertEquals((Object)"mock://result Expected 2 properties with key[foo], received 1 properties. Expected property values: [456]", (Object)((Throwable)((Object)e)).getMessage());
    }

    @Test
    public void testNoDuplicateMessagesPass() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsNoDuplicates((Expression)MockEndpointTest.header("counter"));
        this.sendMessages(11, 12, 13, 14, 15);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testDuplicateMessagesFail() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsNoDuplicates((Expression)MockEndpointTest.header("counter"));
        this.sendMessages(11, 12, 13, 14, 12);
        resultEndpoint.assertIsNotSatisfied();
    }

    @Test
    public void testExpectationsAfterMessagesArrivePass() throws Exception {
        this.sendMessages(11, 12, 13, 14, 12);
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(5);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testExpectationsAfterMessagesArriveFail() throws Exception {
        this.sendMessages(11, 12, 13, 14, 12);
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(6);
        resultEndpoint.setResultWaitTime(500L);
        resultEndpoint.assertIsNotSatisfied();
    }

    @Test
    public void testReset() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(2);
        this.sendMessages(11, 12);
        resultEndpoint.assertIsSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedMessageCount(3);
        this.sendMessages(11, 12, 13);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testExpectationOfHeader() throws InterruptedException {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header", (Object)"value");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header", (Object)"value1");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsNotSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header1", (Object)"value");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsNotSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header1", (Object)"value1");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsNotSatisfied();
    }

    @Test
    public void testExpectationOfHeaderWithNumber() throws InterruptedException {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("number", (Object)123);
        this.sendHeader("number", 123);
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testAscending() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsAscending().body();
        mock.expectsAscending().header("counter");
        this.sendMessages(1, 2, 3, 4, 5);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAscendingFailed() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsAscending().body();
        mock.expectsAscending().header("counter");
        this.sendMessages(1, 2, 5, 3, 4);
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testDescending() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsDescending().body();
        mock.expectsDescending().header("counter");
        this.sendMessages(5, 4, 3, 2, 1);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDescendingFaied() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsDescending().body();
        mock.expectsDescending().header("counter");
        this.sendMessages(5, 4, 2, 3, 1);
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testNoDuplicates() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsNoDuplicates().body();
        mock.expectsNoDuplicates().header("counter");
        this.sendMessages(1, 2, 3, 4, 5);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNoDuplicatesFaied() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsNoDuplicates().body();
        mock.expectsNoDuplicates().header("counter");
        this.sendMessages(1, 2, 5, 2, 4);
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodyReceived().constant((Object)"<message>1</message>");
        this.sendMessages(1);
        mock.assertIsSatisfied();
    }

    @Test
    public void testBodyTransformed() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodyReceived().method("foo", "greet");
        this.template.sendBody("direct:b", (Object)"Hello");
        mock.assertIsSatisfied();
    }

    @Test
    public void testBodyFailed() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodyReceived().constant((Object)"<message>2</message>");
        this.sendMessages(1);
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testSimulateError() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.whenAnyExchangeReceived(exchange -> exchange.setException((Throwable)new IllegalArgumentException("Forced")));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:a", (Object)"Hello World"), (String)"Should have thrown an exception");
        MockEndpointTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getMessage());
    }

    @Test
    public void testSimulateErrorByThrowingException() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.whenAnyExchangeReceived(exchange -> {
            throw new IllegalArgumentException("Forced");
        });
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:a", (Object)"Hello World"), (String)"Should have thrown an exception");
        MockEndpointTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getMessage());
    }

    @Test
    public void testSimulateErrorWithIndex() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.whenExchangeReceived(2, exchange -> exchange.setException((Throwable)new IllegalArgumentException("Forced")));
        this.template.sendBody("direct:a", (Object)"Hello World");
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:a", (Object)"Hello World"), (String)"Should have thrown an exception");
        MockEndpointTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getMessage());
    }

    @Test
    public void testSimulateErrorWithIndexByThrowingException() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.whenExchangeReceived(2, exchange -> {
            throw new IllegalArgumentException("Forced");
        });
        this.template.sendBody("direct:a", (Object)"Hello World");
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:a", (Object)"Bye World"), (String)"Should have thrown an exception");
        MockEndpointTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getMessage());
    }

    @Test
    public void testMinimumCount() throws Exception {
        MockEndpoint mock = MockEndpoint.resolve((CamelContext)this.context, (String)"mock:result");
        mock.expectedMinimumMessageCount(2);
        this.sendMessages(3, 4, 5);
        mock.assertIsSatisfied();
        Assertions.assertEquals((int)2, (int)mock.getExpectedMinimumCount());
    }

    @Test
    public void testResolve() throws Exception {
        MockEndpoint mock = MockEndpoint.resolve((CamelContext)this.context, (String)"mock:result");
        mock.expectedMessageCount(2);
        mock.setResultWaitTime(100L);
        this.template.sendBody("direct:a", (Object)"Hello World");
        mock.assertIsNotSatisfied();
        Assertions.assertEquals((long)100L, (long)mock.getResultWaitTime());
    }

    @Test
    public void testResolveTimeout() throws Exception {
        MockEndpoint mock = MockEndpoint.resolve((CamelContext)this.context, (String)"mock:result");
        mock.expectedMessageCount(2);
        mock.setResultWaitTime(100L);
        mock.assertIsNotSatisfied(500L);
        Assertions.assertEquals((int)2, (int)mock.getExpectedCount());
        Assertions.assertEquals((long)100L, (long)mock.getResultWaitTime());
    }

    @Test
    public void testSleepForEmptyTest() throws Exception {
        MockEndpoint mock = MockEndpoint.resolve((CamelContext)this.context, (String)"mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        mock.assertIsSatisfied();
        Assertions.assertEquals((int)0, (int)mock.getExpectedCount());
        Assertions.assertEquals((long)100L, (long)mock.getSleepForEmptyTest());
    }

    @Test
    public void testSleepForEmptyTestAssert() throws Exception {
        MockEndpoint mock = MockEndpoint.resolve((CamelContext)this.context, (String)"mock:result");
        mock.expectedMessageCount(0);
        mock.assertIsSatisfied(100L);
        Assertions.assertEquals((int)0, (int)mock.getExpectedCount());
        Assertions.assertEquals((long)0L, (long)mock.getSleepForEmptyTest());
        Assertions.assertEquals((long)0L, (long)mock.getResultWaitTime());
    }

    @Test
    public void testReporter() throws Exception {
        AtomicBoolean reported = new AtomicBoolean();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setExpectedMessageCount(1);
        mock.setReporter(exchange -> reported.set(true));
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)mock.getReporter());
        Assertions.assertTrue((boolean)reported.get());
    }

    @Test
    public void testNoArgCtr() {
        MockEndpoint mock = new MockEndpoint("mock:bar", (Component)new MockComponent((CamelContext)this.context));
        Assertions.assertThrows(Exception.class, () -> mock.createConsumer(null), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)0, (int)mock.getFailures().size());
    }

    @Test
    public void testHeaderMissing() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"cheese");
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.assertMockEndpointsSatisfied(), (String)"Should have thrown exception"));
        Assertions.assertEquals((Object)"mock://result No header with name bar found for message: 0", (Object)((Throwable)((Object)e)).getMessage());
    }

    @Test
    public void testHeaderNoMessageSent() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.setResultWaitTime(5L);
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> ((MockEndpoint)mock).assertIsSatisfied(), (String)"Should fail"));
        Assertions.assertEquals((Object)"mock://result Received message count 0, expected at least 1", (Object)((Throwable)((Object)e)).getMessage());
    }

    @Test
    public void testHeaderInvalidValue() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("bar", (Object)"cheese");
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "bar", (Object)"beer");
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.assertMockEndpointsSatisfied(), (String)"Should have thrown exception"));
        Assertions.assertEquals((Object)"mock://result Header with name bar for message: 0. Expected: <cheese> but was: <beer>", (Object)((Throwable)((Object)e)).getMessage());
    }

    @Test
    public void testPropertyMissing() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"cheese");
        this.template.sendBodyAndProperty("direct:a", (Object)"Hello World", "foo", (Object)123);
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.assertMockEndpointsSatisfied(), (String)"Should have thrown exception"));
        Assertions.assertEquals((Object)"mock://result No property with name bar found for message: 0", (Object)((Throwable)((Object)e)).getMessage());
    }

    @Test
    public void testPropertyExpectedNull() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).exchangeProperty("foo")).isNull();
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", (Object)123);
            }
        });
        mock.assertIsNotSatisfied();
        this.resetMocks();
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", null);
            }
        });
        mock.assertIsSatisfied();
        this.resetMocks();
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
            }
        });
        mock.assertIsSatisfied();
    }

    @Test
    public void testPropertyInvalidValue() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("bar", (Object)"cheese");
        this.template.sendBodyAndProperty("direct:a", (Object)"Hello World", "bar", (Object)"beer");
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.assertMockEndpointsSatisfied(), (String)"Should have thrown exception"));
        Assertions.assertEquals((Object)"mock://result Property with name bar for message: 0. Expected: <cheese> but was: <beer>", (Object)((Throwable)((Object)e)).getMessage());
    }

    @Test
    public void testMessageIndexIsEqualTo() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).header("foo")).isEqualTo((Object)123);
        ((MockValueBuilder)mock.message(1).header("bar")).isEqualTo((Object)444);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "bar", (Object)234);
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.assertMockEndpointsSatisfied(), (String)"Should have thrown exception"));
        String s = "Assertion error at index 1 on mock mock://result with predicate: header(bar) == 444 evaluated as: 234 == 444";
        Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(s));
    }

    @Test
    public void testPredicateEvaluationIsNull() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).header("foo")).isNotNull();
        ((MockValueBuilder)mock.message(1).header("bar")).isNull();
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "bar", (Object)234);
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.assertMockEndpointsSatisfied(), (String)"Should have thrown exception"));
        String s = "Assertion error at index 1 on mock mock://result with predicate: header(bar) is null evaluated as: 234 is null";
        Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(s));
    }

    @Test
    public void testPredicateEvaluationIsInstanceOf() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).header("foo")).isNotNull();
        ((MockValueBuilder)mock.message(1).header("bar")).isInstanceOf(String.class);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "bar", (Object)234);
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> this.assertMockEndpointsSatisfied(), (String)"Should have thrown exception"));
        String s = "Assertion error at index 1 on mock mock://result with predicate: header(bar) instanceof java.lang.String";
        Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(s));
    }

    @Test
    public void testExchangePattern() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        ((MockValueBuilder)mock.message(1).exchangePattern()).isEqualTo((Object)ExchangePattern.InOut);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.template.requestBody("direct:a", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotExchangePattern() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        ((MockValueBuilder)mock.message(1).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.template.requestBody("direct:a", (Object)"Bye World");
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testBodyPredicate() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).body()).matches().constant((Object)"Hello World");
        ((MockValueBuilder)mock.message(1).body()).matches().constant((Object)"Bye World");
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:a", (Object)"Bye World", "bar", (Object)234);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotBodyPredicate() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).body()).matches().constant((Object)"Hello World");
        ((MockValueBuilder)mock.message(1).body()).matches().constant((Object)"Hi World");
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:a", (Object)"Bye World", "bar", (Object)234);
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testHeaderPredicate() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).header("foo")).matches().constant((Object)123);
        ((MockValueBuilder)mock.message(1).header("bar")).matches().constant((Object)234);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:a", (Object)"Bye World", "bar", (Object)234);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNotHeaderPredicate() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).header("foo")).matches().constant((Object)123);
        ((MockValueBuilder)mock.message(1).header("bar")).matches().constant((Object)666);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:a", (Object)"Bye World", "bar", (Object)234);
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testExpectedExchangePattern() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedExchangePattern(ExchangePattern.InOnly);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.template.sendBody("direct:a", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        mock.expectedMessageCount(1);
        mock.expectedExchangePattern(ExchangePattern.InOut);
        this.template.requestBody("direct:a", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSetMultipleExpectedHeaders() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"beer");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 123);
        map.put("bar", "beer");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsSatisfied();
    }

    @Test
    public void testSetMultipleExpectedHeaders2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"beer");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 123);
        map.put("bar", "beer");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsSatisfied();
    }

    @Test
    public void testSetMultipleExpectedHeaders3() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", null);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("foo", 123);
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsSatisfied();
    }

    @Test
    public void testSetMultipleExpectedHeaders4() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream("Test".getBytes());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"Test");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 123);
        map.put("bar", is);
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsSatisfied();
    }

    @Test
    public void testSetMultipleExpectedHeadersShouldFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"beer");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 456);
        map.put("bar", "beer");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testSetMultipleExpectedHeadersShouldFail2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"beer");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 123);
        map.put("bar", "wine");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testSetMultipleExpectedHeadersShouldFail3() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"beer");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 123);
        map.put("bar", "beer");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        map = new HashMap();
        map.put("foo", 123);
        map.put("bar", "wine");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testSetMultipleExpectedProperties() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"beer");
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"beer");
            }
        });
        mock.assertIsSatisfied();
    }

    @Test
    public void testSetMultipleExpectedProperties2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"beer");
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"beer");
            }
        });
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"beer");
            }
        });
        mock.assertIsSatisfied();
    }

    @Test
    public void testSetMultipleExpectedProperties3() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", null);
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", (Object)123);
            }
        });
        mock.assertIsSatisfied();
    }

    @Test
    public void testSetMultipleExpectedPropertiesShouldFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"beer");
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", (Object)456);
                exchange.setProperty("bar", (Object)"beer");
            }
        });
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testSetMultipleExpectedPropertiesShouldFail2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"beer");
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"wine");
            }
        });
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testSetMultipleExpectedPropertiesShouldFail3() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"beer");
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"beer");
            }
        });
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"wine");
            }
        });
        mock.assertIsNotSatisfied();
    }

    @Test
    public void testExpectedBodyTypeCoerce() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{987});
        this.template.sendBody("direct:a", (Object)"0987");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testResetDefaultProcessor() throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                counter.incrementAndGet();
            }
        });
        mock.expectedMessageCount(1);
        this.sendMessages(1);
        mock.assertIsSatisfied();
        Assertions.assertEquals((int)1, (int)counter.get());
        this.resetMocks();
        mock.expectedMessageCount(1);
        this.sendMessages(1);
        mock.assertIsSatisfied();
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    public void testRetainFirst() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainFirst(5);
        mock.expectedMessageCount(10);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)10, (int)mock.getReceivedCounter());
        Assertions.assertEquals((int)5, (int)mock.getExchanges().size());
        Assertions.assertEquals((int)5, (int)mock.getReceivedExchanges().size());
        Assertions.assertEquals((Object)"<message>0</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>1</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>2</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>3</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>4</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
    }

    @Test
    public void testRetainLast() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainLast(5);
        mock.expectedMessageCount(10);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)10, (int)mock.getReceivedCounter());
        Assertions.assertEquals((int)5, (int)mock.getExchanges().size());
        Assertions.assertEquals((int)5, (int)mock.getReceivedExchanges().size());
        Assertions.assertEquals((Object)"<message>5</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>6</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>7</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>8</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>9</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
    }

    @Test
    public void testRetainFirstAndLast() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainFirst(5);
        mock.setRetainLast(5);
        mock.expectedMessageCount(20);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)20, (int)mock.getReceivedCounter());
        Assertions.assertEquals((int)10, (int)mock.getExchanges().size());
        Assertions.assertEquals((int)10, (int)mock.getReceivedExchanges().size());
        Assertions.assertEquals((Object)"<message>0</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>1</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>2</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>3</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>4</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>15</message>", (Object)((Exchange)mock.getReceivedExchanges().get(5)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>16</message>", (Object)((Exchange)mock.getReceivedExchanges().get(6)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>17</message>", (Object)((Exchange)mock.getReceivedExchanges().get(7)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>18</message>", (Object)((Exchange)mock.getReceivedExchanges().get(8)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>19</message>", (Object)((Exchange)mock.getReceivedExchanges().get(9)).getIn().getBody());
    }

    @Test
    public void testRetainFirstAndLastOverlap() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainFirst(5);
        mock.setRetainLast(5);
        mock.expectedMessageCount(8);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)8, (int)mock.getReceivedCounter());
        Assertions.assertEquals((int)8, (int)mock.getExchanges().size());
        Assertions.assertEquals((int)8, (int)mock.getReceivedExchanges().size());
        Assertions.assertEquals((Object)"<message>0</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>1</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>2</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>3</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>4</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>5</message>", (Object)((Exchange)mock.getReceivedExchanges().get(5)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>6</message>", (Object)((Exchange)mock.getReceivedExchanges().get(6)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>7</message>", (Object)((Exchange)mock.getReceivedExchanges().get(7)).getIn().getBody());
    }

    @Test
    public void testRetainFirstAndLastNoGap() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainFirst(5);
        mock.setRetainLast(5);
        mock.expectedMessageCount(10);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)10, (int)mock.getReceivedCounter());
        Assertions.assertEquals((int)10, (int)mock.getExchanges().size());
        Assertions.assertEquals((int)10, (int)mock.getReceivedExchanges().size());
        Assertions.assertEquals((Object)"<message>0</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>1</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>2</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>3</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>4</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>5</message>", (Object)((Exchange)mock.getReceivedExchanges().get(5)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>6</message>", (Object)((Exchange)mock.getReceivedExchanges().get(6)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>7</message>", (Object)((Exchange)mock.getReceivedExchanges().get(7)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>8</message>", (Object)((Exchange)mock.getReceivedExchanges().get(8)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>9</message>", (Object)((Exchange)mock.getReceivedExchanges().get(9)).getIn().getBody());
    }

    @Test
    public void testRetainFirstAndLastSingleGap() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainFirst(5);
        mock.setRetainLast(5);
        mock.expectedMessageCount(11);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)11, (int)mock.getReceivedCounter());
        Assertions.assertEquals((int)10, (int)mock.getExchanges().size());
        Assertions.assertEquals((int)10, (int)mock.getReceivedExchanges().size());
        Assertions.assertEquals((Object)"<message>0</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>1</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>2</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>3</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>4</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>6</message>", (Object)((Exchange)mock.getReceivedExchanges().get(5)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>7</message>", (Object)((Exchange)mock.getReceivedExchanges().get(6)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>8</message>", (Object)((Exchange)mock.getReceivedExchanges().get(7)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>9</message>", (Object)((Exchange)mock.getReceivedExchanges().get(8)).getIn().getBody());
        Assertions.assertEquals((Object)"<message>10</message>", (Object)((Exchange)mock.getReceivedExchanges().get(9)).getIn().getBody());
    }

    @Test
    public void testExpectedMessagesMatches() throws Exception {
        Language sl = this.context.resolveLanguage("simple");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessagesMatches(new Predicate[]{sl.createPredicate("${body} == 'abc'")});
        this.template.sendBody("direct:a", (Object)"abc");
        mock.assertIsSatisfied();
        mock.reset();
        mock.expectedMessagesMatches(new Predicate[]{sl.createPredicate("${body} == 'abc'")});
        this.template.sendBody("direct:a", (Object)"def");
        mock.assertIsNotSatisfied();
    }

    protected void sendMessages(int ... counters) {
        for (int counter : counters) {
            this.template.sendBodyAndHeader("direct:a", (Object)this.createTestMessage(counter), "counter", (Object)counter);
        }
    }

    private String createTestMessage(int counter) {
        return "<message>" + counter + "</message>";
    }

    protected Object[] listOfMessages(int ... counters) {
        ArrayList<String> list = new ArrayList<String>(counters.length);
        for (int counter : counters) {
            list.add(this.createTestMessage(counter));
        }
        return list.toArray();
    }

    protected void sendHeader(String name, Object value) {
        this.template.sendBodyAndHeader("direct:a", (Object)"body", name, value);
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("foo", (Object)new MyHelloBean());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").to("mock:result");
                ((RouteDefinition)this.from("direct:b").transform((Expression)this.body().append((Object)" World"))).to("mock:result");
            }
        };
    }

    public static final class MyHelloBean {
        public String greet() {
            return "Hello World";
        }
    }
}

