/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Test;

public class MockAssertionClauseTest
extends ContextTestSupport {
    @Test
    public void testAssertionClauseAll() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.allMessages().xpath("/person[@name='James']");
        this.template.sendBody("direct:start", (Object)"<person name='James' last='Hanson'/>");
        this.template.sendBody("direct:start", (Object)"<person name='James' last='Jackson'/>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAssertionClausePer() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.message(0).xpath("/person[@last='Hanson']");
        ((MockValueBuilder)mock.message(0).body()).contains((Object)"Hanson");
        mock.message(1).xpath("/person[@last='Jackson']");
        ((MockValueBuilder)mock.message(1).body()).contains((Object)"Jackson");
        this.template.sendBody("direct:start", (Object)"<person name='James' last='Hanson'/>");
        this.template.sendBody("direct:start", (Object)"<person name='James' last='Jackson'/>");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

