/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class MockAsBeanTest
extends ContextTestSupport {
    private final MockEndpoint foo = new MockEndpoint("mock:foo", (Component)new MockComponent());

    @Test
    public void testMockAsBeanWithWhenAnyExchangeReceived() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.foo.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                String in = (String)exchange.getIn().getBody(String.class);
                exchange.getIn().setBody((Object)("Bye " + in));
            }
        });
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MockAsBeanTest.this.context.getRegistry().bind("foo", (Object)MockAsBeanTest.this.foo);
                ((RouteDefinition)this.from("direct:start").bean((Object)"foo")).to("mock:result");
            }
        };
    }

    @Test
    public void testMockAsBeanWithReplyBody() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.foo.returnReplyBody(ExpressionBuilder.simpleExpression((String)"Bye ${body}"));
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMockAsBeanWithReplyHeader() throws Exception {
        this.getMockEndpoint("mock:result").expectedHeaderReceived("myHeader", (Object)"Bye World");
        this.foo.returnReplyHeader("myHeader", ExpressionBuilder.simpleExpression((String)"Bye ${body}"));
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }
}

