/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.ContextTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRouteTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(LogRouteTest.class);

    @Test
    public void testSendMessageToLog() {
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST", (Object)"<level>default</level>"));
    }

    @Test
    public void testSendMessageToInfoLog() {
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?level=INFO", (Object)"<level>INFO</level>"));
    }

    @Test
    public void testSendMessageToWarnLog() {
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?level=warn", (Object)"<level>WARN</level>"));
    }

    @Test
    public void testSendMessageToBadLevel() {
        Exception ex = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("log:org.apache.camel.TEST?level=noSuchLevel", (Object)"<level>noSuchLevel</level>"), (String)"Should have failed!");
        LOG.debug("Caught expected exception: {}", (Object)ex.getMessage(), (Object)ex);
    }
}

