/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogMaskTest {
    protected Registry registry;

    protected CamelContext createCamelContext() {
        this.registry = new DefaultRegistry();
        return new DefaultCamelContext(this.registry);
    }

    @Test
    public void testLogMask() throws Exception {
        CamelContext context = this.createCamelContext();
        context.setLogMask(Boolean.valueOf(true));
        context.start();
        ProducerTemplate template = context.createProducerTemplate();
        Assertions.assertDoesNotThrow(() -> template.sendBodyAndHeader("log:mask?showHeaders=true", (Object)"password=passw0rd@", "headerPassword", (Object)"#header-password$"));
        Assertions.assertDoesNotThrow(() -> template.sendBodyAndProperty("log:mask?showProperties=true", (Object)"password=passw0rd@", "propertyPassphrase", (Object)"#property-passphrase$"));
        context.stop();
    }

    @Test
    public void testDisableLogMaskViaParam() throws Exception {
        CamelContext context = this.createCamelContext();
        context.setLogMask(Boolean.valueOf(true));
        context.start();
        ProducerTemplate template = context.createProducerTemplate();
        Assertions.assertDoesNotThrow(() -> template.sendBodyAndHeader("log:mask?showHeaders=true", (Object)"password=passw0rd@", "headerPassword", (Object)"#header-password$"));
        Assertions.assertDoesNotThrow(() -> template.sendBodyAndProperty("log:no-mask?showProperties=true&logMask=false", (Object)"password=passw0rd@", "propertyPassphrase", (Object)"#property-passphrase$"));
        context.stop();
    }

    @Test
    public void testCustomFormatter() throws Exception {
        CamelContext context = this.createCamelContext();
        MockMaskingFormatter customFormatter = new MockMaskingFormatter();
        this.registry.bind("CamelCustomLogMask", (Object)customFormatter);
        context.start();
        ProducerTemplate template = context.createProducerTemplate();
        template.sendBody("log:mock?logMask=true", (Object)"password=passw0rd@");
        context.stop();
        Assertions.assertTrue((boolean)customFormatter.received.contains("password=passw0rd@"), (String)customFormatter.received);
    }

    public static class MockMaskingFormatter
    implements MaskingFormatter {
        private String received;

        public String format(String source) {
            this.received = source;
            return source;
        }
    }
}

