/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogListenerTest {
    private static boolean listenerFired;

    @Test
    public void testLogMask() throws Exception {
        listenerFired = false;
        CamelContext context = this.createCamelContext();
        MockEndpoint mock = (MockEndpoint)context.getEndpoint("mock:foo", MockEndpoint.class);
        mock.expectedMessageCount(1);
        context.getCamelContextExtension().addLogListener((exchange, camelLogger, message) -> {
            Assertions.assertEquals((Object)"Exchange[ExchangePattern: InOnly, BodyType: String, Body: hello]", (Object)message);
            listenerFired = true;
            return message + " - modified by listener";
        });
        context.start();
        context.createProducerTemplate().sendBody("direct:foo", (Object)"hello");
        mock.assertIsSatisfied();
        Assertions.assertTrue((boolean)listenerFired);
        context.stop();
    }

    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:foo").routeId("foo").to("log:foo")).to("mock:foo");
            }
        };
    }
}

