/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.io.ByteArrayInputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class LogInputStreamTest
extends ContextTestSupport {
    @Test
    public void testA() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:a");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ByteArrayInputStream is = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:a", (Object)is);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testB() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:b");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).convertToString().isEqualTo((Object)"Hello World");
        ByteArrayInputStream is = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:b", (Object)is);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:c");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ByteArrayInputStream is = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:c", (Object)is);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testD() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:d");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ByteArrayInputStream is = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:d", (Object)is);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testE() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:e");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ByteArrayInputStream is = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:e", (Object)is);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testF() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:f");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ByteArrayInputStream is = new ByteArrayInputStream("Hello World".getBytes());
        this.template.sendBody("direct:f", (Object)is);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:a").noStreamCaching().to("log:a")).to("mock:a");
                ((RouteDefinition)this.from("direct:b").noStreamCaching().to("log:b?showStreams=true")).to("mock:b");
                ((RouteDefinition)this.from("direct:c").streamCaching().to("log:c")).to("mock:c");
                ((RouteDefinition)this.from("direct:d").streamCaching().to("log:d?showStreams=true")).to("mock:d");
                ((RouteDefinition)this.from("direct:e").streamCaching().to("log:e?showCachedStreams=true")).to("mock:e");
                ((RouteDefinition)this.from("direct:f").streamCaching().to("log:f?showCachedStreams=false")).to("mock:f");
            }
        };
    }
}

