/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.LogListener;
import org.apache.camel.support.processor.CamelLogProcessor;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogEndpointTest
extends ContextTestSupport {
    private static Exchange logged;

    @AfterAll
    public static void clean() {
        logged = null;
    }

    @Test
    public void testLogEndpoint() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start1", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotNull((Object)logged);
    }

    @Test
    public void testLogEndpointGroupSize() throws InterruptedException {
        MockEndpoint out = this.getMockEndpoint("mock:result");
        int expectedCount = 50;
        out.expectedMessageCount(expectedCount);
        for (int i = 0; i < expectedCount; ++i) {
            this.template.sendBody("direct:start2", (Object)"blub");
        }
        out.assertIsSatisfied();
    }

    @Test
    public void testShowCaughtException() {
        AtomicReference<String> logged = new AtomicReference<String>();
        this.context.getCamelContextExtension().addLogListener((LogListener)new TestLogListener(logged));
        Exchange ex = this.createExchangeWithBody(null);
        ex.setProperty("CamelExceptionCaught", (Object)new RuntimeException("test"));
        this.template.send("log:testShowCaughtException?showCaughtException=true", ex);
        Assertions.assertEquals((Object)"Exchange[BodyType: null, Body: [Body is null], CaughtExceptionType: java.lang.RuntimeException, CaughtExceptionMessage: test]", (Object)logged.get());
    }

    @Test
    public void testShowException() {
        AtomicReference<String> logged = new AtomicReference<String>();
        this.context.getCamelContextExtension().addLogListener((LogListener)new TestLogListener(logged));
        Exchange ex = this.createExchangeWithBody(null);
        ex.setException((Throwable)new RuntimeException("test"));
        this.template.send("log:testShowException?showException=true", ex);
        Assertions.assertEquals((Object)"Exchange[BodyType: null, Body: [Body is null], ExceptionType: java.lang.RuntimeException, ExceptionMessage: test]", (Object)logged.get());
    }

    @Test
    public void testPlain() {
        String body = "Body as string";
        AtomicReference<String> logged = new AtomicReference<String>();
        this.context.getCamelContextExtension().addLogListener((LogListener)new TestLogListener(logged));
        Exchange ex = this.createExchangeWithBody(body);
        this.template.send("log:info?plain=true", ex);
        Assertions.assertEquals((Object)body, (Object)logged.get());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                LogEndpoint end = new LogEndpoint();
                end.setComponent(LogEndpointTest.this.context.getComponent("log"));
                end.setCamelContext((CamelContext)LogEndpointTest.this.context);
                end.setLogger((Processor)new MyLogger());
                LogEndpoint endpoint = new LogEndpoint();
                endpoint.setLoggerName("loggerSetter");
                endpoint.setGroupSize(Integer.valueOf(10));
                endpoint.setCamelContext((CamelContext)LogEndpointTest.this.context);
                endpoint.setComponent(LogEndpointTest.this.context.getComponent("log"));
                endpoint.start();
                Assertions.assertEquals((Object)"log:myLogger", (Object)end.getEndpointUri());
                ((RouteDefinition)this.from("direct:start1").to((Endpoint)end)).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").to((Endpoint)endpoint)).to("mock:result");
            }
        };
    }

    private static class TestLogListener
    implements LogListener {
        private final AtomicReference<String> logged;

        public TestLogListener(AtomicReference<String> logged) {
            this.logged = logged;
        }

        public String onLog(Exchange exchange, CamelLogger camelLogger, String message) {
            this.logged.set(message);
            return message;
        }
    }

    private static class MyLogger
    extends CamelLogProcessor {
        private MyLogger() {
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            logged = exchange;
            return super.process(exchange, callback);
        }

        public String toString() {
            return "myLogger";
        }
    }
}

