/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.io.StringWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.log.ConsumingAppender;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.logging.log4j.Level;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

public class LogCustomLoggerTest
extends ContextTestSupport {
    private static StringWriter sw1;
    private static StringWriter sw2;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        sw1 = new StringWriter();
        sw2 = new StringWriter();
        ConsumingAppender.newAppender(LogCustomLoggerTest.class.getCanonicalName(), "LogCustomLoggerTest", Level.TRACE, event -> sw1.append(event.getLoggerName()));
        ConsumingAppender.newAppender("provided.logger1.name", "logger1", Level.TRACE, event -> sw1.append(event.getLoggerName()));
        ConsumingAppender.newAppender("provided.logger2.name", "logger2", Level.TRACE, event -> sw1.append(event.getLoggerName()));
        ConsumingAppender.newAppender("irrelevant.logger.name", "irrelevant", Level.TRACE, event -> sw1.append(event.getLoggerName()));
        ConsumingAppender.newAppender(LogComponent.class.getCanonicalName(), "LogComponent", Level.INFO, event -> sw2.append(event.getLoggerName()));
    }

    @Test
    public void testFallbackLogger() {
        String endpointUri = "log:" + LogCustomLoggerTest.class.getCanonicalName();
        this.template.requestBody(endpointUri, (Object)"hello");
        MatcherAssert.assertThat((Object)sw1.toString(), (Matcher)CoreMatchers.equalTo((Object)LogCustomLoggerTest.class.getCanonicalName()));
    }

    @Test
    public void testEndpointURIParametrizedLogger() {
        this.context.getRegistry().bind("logger1", (Object)LoggerFactory.getLogger((String)"provided.logger1.name"));
        this.context.getRegistry().bind("logger2", (Object)LoggerFactory.getLogger((String)"provided.logger2.name"));
        this.template.requestBody("log:irrelevant.logger.name?logger=#logger2", (Object)"hello");
        MatcherAssert.assertThat((Object)sw1.toString(), (Matcher)CoreMatchers.equalTo((Object)"provided.logger2.name"));
    }

    @Test
    public void testEndpointURIParametrizedNotResolvableLogger() {
        this.context.getRegistry().bind("logger1", (Object)LoggerFactory.getLogger((String)"provided.logger1.name"));
        Assertions.assertThrows(ResolveEndpointFailedException.class, () -> this.template.requestBody("log:irrelevant.logger.name?logger=#logger2", (Object)"hello"), (String)"Endpoint cannot be resolved via URI");
    }

    @Test
    public void testDefaultRegistryLogger() {
        this.context.getRegistry().bind("logger", (Object)LoggerFactory.getLogger((String)"provided.logger1.name"));
        this.template.requestBody("log:irrelevant.logger.name", (Object)"hello");
        MatcherAssert.assertThat((Object)sw1.toString(), (Matcher)CoreMatchers.equalTo((Object)"provided.logger1.name"));
    }

    @Test
    public void testTwoRegistryLoggers() {
        this.context.getRegistry().bind("logger1", (Object)LoggerFactory.getLogger((String)"provided.logger1.name"));
        this.context.getRegistry().bind("logger2", (Object)LoggerFactory.getLogger((String)"provided.logger2.name"));
        this.template.requestBody("log:irrelevant.logger.name", (Object)"hello");
        MatcherAssert.assertThat((Object)sw1.toString(), (Matcher)CoreMatchers.equalTo((Object)"irrelevant.logger.name"));
        MatcherAssert.assertThat((Object)sw2.toString(), (Matcher)CoreMatchers.equalTo((Object)LogComponent.class.getName()));
    }

    @Override
    protected CamelContext createCamelContext() {
        return new DefaultCamelContext();
    }
}

