/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogComponentOptionsTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testFastLogComponentOptions() {
        this.context.start();
        long before = PluginHelper.getBeanIntrospection((CamelContext)this.context).getInvokedCounter();
        DefaultExchangeFormatter myFormatter = new DefaultExchangeFormatter();
        LogComponent log = (LogComponent)this.context.getComponent("log", LogComponent.class);
        Assertions.assertNull((Object)log.getExchangeFormatter());
        new PropertyBindingSupport.Builder().withCamelContext((CamelContext)this.context).withTarget((Object)log).withConfigurer(log.getComponentPropertyConfigurer()).withProperty("exchangeFormatter", (Object)myFormatter).bind();
        Assertions.assertSame((Object)myFormatter, (Object)log.getExchangeFormatter());
        long after = PluginHelper.getBeanIntrospection((CamelContext)this.context).getInvokedCounter();
        Assertions.assertEquals((long)before, (long)after, (String)"Should not use Java reflection");
    }

    @Test
    public void testFastLogComponentNestedOptions() {
        this.context.start();
        long before = PluginHelper.getBeanIntrospection((CamelContext)this.context).getInvokedCounter();
        DefaultExchangeFormatter myFormatter = new DefaultExchangeFormatter();
        LogComponent log = (LogComponent)this.context.getComponent("log", LogComponent.class);
        Assertions.assertNull((Object)log.getExchangeFormatter());
        new PropertyBindingSupport.Builder().withCamelContext((CamelContext)this.context).withTarget((Object)log).withConfigurer(log.getComponentPropertyConfigurer()).withProperty("exchangeFormatter", (Object)myFormatter).withProperty("exchangeFormatter.showExchangeId", (Object)"true").bind();
        Assertions.assertSame((Object)myFormatter, (Object)log.getExchangeFormatter());
        long after = PluginHelper.getBeanIntrospection((CamelContext)this.context).getInvokedCounter();
        Assertions.assertEquals((long)before, (long)after, (String)"Should not use Java reflection");
    }

    @Test
    public void testFastLogComponentOptionsLookupRegistry() {
        this.context.start();
        long before = PluginHelper.getBeanIntrospection((CamelContext)this.context).getInvokedCounter();
        DefaultExchangeFormatter myFormatter = new DefaultExchangeFormatter();
        this.context.getRegistry().bind("myGreatFormatter", (Object)myFormatter);
        DefaultExchangeFormatter mySecondFormatter = new DefaultExchangeFormatter();
        this.context.getRegistry().bind("mySecondFormatter", (Object)mySecondFormatter);
        LogComponent log = (LogComponent)this.context.getComponent("log", LogComponent.class);
        Assertions.assertNull((Object)log.getExchangeFormatter());
        new PropertyBindingSupport.Builder().withCamelContext((CamelContext)this.context).withTarget((Object)log).withConfigurer(log.getComponentPropertyConfigurer()).withProperty("exchangeFormatter", (Object)"#bean:myGreatFormatter").bind();
        Assertions.assertSame((Object)myFormatter, (Object)log.getExchangeFormatter());
        long after = PluginHelper.getBeanIntrospection((CamelContext)this.context).getInvokedCounter();
        Assertions.assertEquals((long)before, (long)after, (String)"Should not use Java reflection");
    }

    @Test
    public void testSlowLogComponentOptions() {
        this.context.start();
        long before = PluginHelper.getBeanIntrospection((CamelContext)this.context).getInvokedCounter();
        DefaultExchangeFormatter myFormatter = new DefaultExchangeFormatter();
        LogComponent log = (LogComponent)this.context.getComponent("log", LogComponent.class);
        Assertions.assertNull((Object)log.getExchangeFormatter());
        new PropertyBindingSupport.Builder().withCamelContext((CamelContext)this.context).withTarget((Object)log).withProperty("exchangeFormatter", (Object)myFormatter).withProperty("exchangeFormatter.showExchangeId", (Object)"true").bind();
        Assertions.assertSame((Object)myFormatter, (Object)log.getExchangeFormatter());
        Assertions.assertTrue((boolean)myFormatter.isShowExchangeId());
        long after = PluginHelper.getBeanIntrospection((CamelContext)this.context).getInvokedCounter();
        Assertions.assertTrue((after > before ? 1 : 0) != 0, (String)"Should use reflection");
    }

    @Test
    public void testSlowLogComponentOptionsLookupRegistry() {
        this.context.start();
        long before = PluginHelper.getBeanIntrospection((CamelContext)this.context).getInvokedCounter();
        DefaultExchangeFormatter myFormatter = new DefaultExchangeFormatter();
        this.context.getRegistry().bind("myGreatFormatter", (Object)myFormatter);
        DefaultExchangeFormatter mySecondFormatter = new DefaultExchangeFormatter();
        this.context.getRegistry().bind("mySecondFormatter", (Object)mySecondFormatter);
        LogComponent log = (LogComponent)this.context.getComponent("log", LogComponent.class);
        Assertions.assertNull((Object)log.getExchangeFormatter());
        new PropertyBindingSupport.Builder().withCamelContext((CamelContext)this.context).withTarget((Object)log).withProperty("exchangeFormatter", (Object)"#bean:myGreatFormatter").withProperty("exchangeFormatter.showExchangeId", (Object)"true").bind();
        Assertions.assertSame((Object)myFormatter, (Object)log.getExchangeFormatter());
        Assertions.assertTrue((boolean)myFormatter.isShowExchangeId());
        long after = PluginHelper.getBeanIntrospection((CamelContext)this.context).getInvokedCounter();
        Assertions.assertTrue((after > before ? 1 : 0) != 0, (String)"Should use reflection");
    }
}

