/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Handler;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Test;

public class LogComponentCustomizeThreeTest
extends ContextTestSupport {
    private final MyService myService = new MyService();

    @Test
    public void testCustomize() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                LogComponentCustomizeThreeTest.this.context.addService((Object)LogComponentCustomizeThreeTest.this.myService);
                this.customize(MyService.class, s -> s.setPrefix("Hello"));
                ((RouteDefinition)this.from("direct:start").bean((Object)LogComponentCustomizeThreeTest.this.myService)).to("mock:result");
            }
        };
    }

    private static final class MyService
    extends ServiceSupport {
        private String prefix;

        private MyService() {
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Handler
        public String hello(String body) {
            return this.prefix + " " + body;
        }
    }
}

