/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LogBodyWithNewLineTest
extends ContextTestSupport {
    private StringWriter writer;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.writer = new StringWriter();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        WriterAppender appender = ((WriterAppender.Builder)((WriterAppender.Builder)WriterAppender.newBuilder().setLayout((Layout)PatternLayout.newBuilder().withPattern("%d [%t] %p %c - %m%n").build())).setTarget((Writer)this.writer).setName("Writer")).build();
        appender.start();
        String loggerName = "logger_name";
        config.removeLogger("logger_name");
        LoggerConfig loggerConfig = LoggerConfig.newBuilder().withIncludeLocation("true").withLoggerName("logger_name").withLevel(Level.INFO).withAdditivity(true).withConfig(config).withRefs(new AppenderRef[]{AppenderRef.createAppenderRef((String)"Writer", null, null)}).build();
        loggerConfig.addAppender((Appender)appender, Level.INFO, null);
        config.addLogger("logger_name", loggerConfig);
        ctx.updateLoggers();
    }

    @Test
    public void testNoSkip() {
        String body = "1" + LS + "2" + LS + "3";
        this.template.sendBody("direct:start", (Object)body);
        this.log.info("{}", (Object)this.writer);
        Assertions.assertTrue((boolean)this.writer.toString().contains(body));
    }

    @Test
    public void testSkip() {
        String body = "1" + LS + "2" + LS + "3";
        this.template.sendBody("direct:skip", (Object)body);
        this.log.info("{}", (Object)this.writer);
        Assertions.assertTrue((boolean)this.writer.toString().contains("123"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("log:logger_name?level=INFO&showAll=true&skipBodyLineSeparator=false");
                this.from("direct:skip").to("log:logger_name?level=INFO&showAll=true&skipBodyLineSeparator=true");
            }
        };
    }
}

