/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultExchangeFormatterTest
extends ContextTestSupport {
    @Test
    public void testSendMessageToLogDefault() {
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST", (Object)"Hello World"));
    }

    @Test
    public void testSendMessageToLogAllOff() {
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showBody=false&showBodyType=false&showExchangePattern=false", (Object)"Hello World"));
    }

    @Test
    public void testSendMessageToLogSingleOptions() {
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showExchangeId=true", (Object)"Hello World"));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showExchangePattern=true", (Object)"Hello World"));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showExchangePattern=false", (Object)"Hello World"));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showProperties=true", (Object)"Hello World"));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showHeaders=true", (Object)"Hello World"));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showBodyType=true", (Object)"Hello World"));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showBody=true", (Object)"Hello World"));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showAll=true", (Object)"Hello World"));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showFuture=true", (Object)new MyFuture(() -> "foo")));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showFuture=false", (Object)new MyFuture(() -> "bar")));
    }

    @Test
    public void testSendMessageToLogMultiOptions() {
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showHeaders=true", (Object)"Hello World"));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showAllProperties=true&showHeaders=true", (Object)"Hello World"));
    }

    @Test
    public void testSendMessageToLogShowFalse() {
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?showBodyType=false", (Object)"Hello World"));
    }

    @Test
    public void testSendMessageToLogMultiLine() {
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?multiline=true", (Object)"Hello World"));
    }

    @Test
    public void testSendByteArrayMessageToLogDefault() {
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST", (Object)"Hello World".getBytes()));
    }

    @Test
    public void testSendMessageToLogMaxChars() {
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST", (Object)"Hello World this is a very long string that is NOT going to be chopped by maxchars"));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?maxChars=50", (Object)"Hello World this is a very long string that is going to be chopped by maxchars"));
        Assertions.assertDoesNotThrow(() -> this.template.sendBody("log:org.apache.camel.TEST?maxChars=50&showAll=true&multiline=true", (Object)"Hello World this is a very long string that is going to be chopped by maxchars"));
    }

    @Test
    public void testSendExchangeWithException() throws Exception {
        Endpoint endpoint = this.resolveMandatoryEndpoint("log:org.apache.camel.TEST?showException=true");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setException((Throwable)new IllegalArgumentException("Damn"));
        Producer producer = endpoint.createProducer();
        producer.start();
        producer.process(exchange);
        this.assertMockEndpointsSatisfied();
        producer.stop();
    }

    @Test
    public void testSendCaughtExchangeWithException() throws Exception {
        Endpoint endpoint = this.resolveMandatoryEndpoint("log:org.apache.camel.TEST?showCaughtException=true");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setProperty("CamelExceptionCaught", (Object)new IllegalArgumentException("I am caught"));
        Producer producer = endpoint.createProducer();
        producer.start();
        producer.process(exchange);
        this.assertMockEndpointsSatisfied();
        producer.stop();
    }

    @Test
    public void testSendCaughtExchangeWithExceptionAndMultiline() throws Exception {
        Endpoint endpoint = this.resolveMandatoryEndpoint("log:org.apache.camel.TEST?showCaughtException=true&multiline=true");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setProperty("CamelExceptionCaught", (Object)new IllegalArgumentException("I am caught"));
        Producer producer = endpoint.createProducer();
        producer.start();
        producer.process(exchange);
        this.assertMockEndpointsSatisfied();
        producer.stop();
    }

    @Test
    public void testSendExchangeWithExceptionAndStackTrace() throws Exception {
        Endpoint endpoint = this.resolveMandatoryEndpoint("log:org.apache.camel.TEST?showException=true&showStackTrace=true");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setException((Throwable)new IllegalArgumentException("Damn"));
        Producer producer = endpoint.createProducer();
        producer.start();
        producer.process(exchange);
        this.assertMockEndpointsSatisfied();
        producer.stop();
    }

    @Test
    public void testSendCaughtExchangeWithExceptionAndStackTrace() throws Exception {
        Endpoint endpoint = this.resolveMandatoryEndpoint("log:org.apache.camel.TEST?showCaughtException=true&showStackTrace=true");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setProperty("CamelExceptionCaught", (Object)new IllegalArgumentException("I am caught"));
        Producer producer = endpoint.createProducer();
        producer.start();
        producer.process(exchange);
        this.assertMockEndpointsSatisfied();
        producer.stop();
    }

    @Test
    public void testConfiguration() {
        DefaultExchangeFormatter formatter = new DefaultExchangeFormatter();
        Assertions.assertFalse((boolean)formatter.isShowExchangeId());
        Assertions.assertFalse((boolean)formatter.isShowProperties());
        Assertions.assertFalse((boolean)formatter.isShowHeaders());
        Assertions.assertFalse((boolean)formatter.isShowVariables());
        Assertions.assertTrue((boolean)formatter.isShowBodyType());
        Assertions.assertTrue((boolean)formatter.isShowBody());
        Assertions.assertFalse((boolean)formatter.isShowException());
        Assertions.assertFalse((boolean)formatter.isShowCaughtException());
        Assertions.assertFalse((boolean)formatter.isShowStackTrace());
        Assertions.assertFalse((boolean)formatter.isShowAll());
        Assertions.assertFalse((boolean)formatter.isMultiline());
        Assertions.assertEquals((int)10000, (int)formatter.getMaxChars());
    }

    private static class MyFuture
    extends FutureTask<String> {
        MyFuture(Callable<String> callable) {
            super(callable);
        }

        MyFuture(Runnable runnable, String o) {
            super(runnable, o);
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public String get() {
            return "foo";
        }

        @Override
        public String toString() {
            return "ThisIsMyFuture";
        }
    }
}

