/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class ConsumingAppender
extends AbstractAppender {
    private final Consumer<LogEvent> consumer;

    public ConsumingAppender(String name, Consumer<LogEvent> consumer) {
        this(name, "%d [%t] %p %c - %m%n", consumer);
    }

    public ConsumingAppender(String name, String pattern, Consumer<LogEvent> consumer) {
        super(name, null, (Layout)PatternLayout.newBuilder().withPattern(pattern).build(), true, Property.EMPTY_ARRAY);
        this.consumer = consumer;
    }

    public void append(LogEvent event) {
        this.consumer.accept(event);
    }

    public static Appender newAppender(String loggerName, String appenderName, Level level, Consumer<LogEvent> consumer) {
        return ConsumingAppender.newAppender(loggerName, appenderName, "%d [%t] %p %c - %m%n", level, consumer);
    }

    public static Appender newAppender(String loggerName, String appenderName, String patter, Level level, Consumer<LogEvent> consumer) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        config.removeLogger(loggerName);
        ConsumingAppender appender = new ConsumingAppender(appenderName, patter, consumer);
        appender.start();
        LoggerConfig loggerConfig = LoggerConfig.newBuilder().withIncludeLocation("true").withLoggerName(loggerName).withLevel(level).withAdditivity(true).withConfig(config).withRefs(new AppenderRef[]{AppenderRef.createAppenderRef((String)appenderName, null, null)}).build();
        loggerConfig.addAppender((Appender)appender, null, null);
        config.addLogger(loggerName, loggerConfig);
        ctx.updateLoggers();
        return appender;
    }
}

