/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class LanguageScriptInHeaderRouteTakePrecedenceTest
extends ContextTestSupport {
    @Test
    public void testLanguageWithHeader() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("direct:start", (Object)"World", "CamelLanguageScript", (Object)"Hello ${body}");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testLanguageNoHeader() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                String script = URLEncoder.encode("Bye ${body}", StandardCharsets.UTF_8);
                ((RouteDefinition)this.from("direct:start").to("language:simple:" + script)).to("mock:result");
            }
        };
    }
}

