/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.language.LanguageEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanguageNoCacheScriptTest
extends ContextTestSupport {
    private LanguageEndpoint endpoint;

    @Test
    public void testNoCache() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"World", "Camel"});
        this.template.sendBody("direct:start", (Object)"World");
        Expression first = this.endpoint.getExpression();
        this.template.sendBody("direct:start", (Object)"Camel");
        Expression second = this.endpoint.getExpression();
        this.assertMockEndpointsSatisfied();
        Assertions.assertSame((Object)first, (Object)second);
        Assertions.assertNull((Object)first);
        Assertions.assertNull((Object)second);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                String script = URLEncoder.encode("Hello ${body}", StandardCharsets.UTF_8);
                LanguageNoCacheScriptTest.this.endpoint = (LanguageEndpoint)LanguageNoCacheScriptTest.this.context.getEndpoint("language:simple:" + script + "?transform=false&cacheScript=false", LanguageEndpoint.class);
                ((RouteDefinition)this.from("direct:start").to((Endpoint)LanguageNoCacheScriptTest.this.endpoint)).to("mock:result");
            }
        };
    }
}

