/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.stress;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="Manual test")
public class FileProducerAppendManyMessagesFastManualTest
extends ContextTestSupport {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(this.testFile("big/data.txt"), new OpenOption[0]));){
            for (int i = 0; i < 1000; ++i) {
                String s = "Hello World this is a long line with number " + i + LS;
                ((OutputStream)fos).write(s.getBytes());
            }
        }
    }

    @Test
    public void testBigFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:done");
        mock.expectedMessageCount(1);
        mock.setResultWaitTime(120000L);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from(FileProducerAppendManyMessagesFastManualTest.this.fileUri("big?initialDelay=1000")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        FileOutputStream fos = new FileOutputStream(FileProducerAppendManyMessagesFastManualTest.this.testFile("out/also-big.txt").toFile(), true);
                        exchange.setProperty("myStream", (Object)fos);
                    }
                })).split((Expression)this.body().tokenize(LS)).streaming().to("log:processing?groupSize=1000")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        OutputStream fos = (OutputStream)exchange.getProperty("myStream", OutputStream.class);
                        byte[] data = (byte[])exchange.getIn().getBody(byte[].class);
                        fos.write(data);
                        fos.write(LS.getBytes());
                    }
                })).end().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        OutputStream fos = (OutputStream)exchange.getProperty("myStream", OutputStream.class);
                        fos.close();
                        exchange.removeProperty("myStream");
                    }
                }).to("mock:done");
            }
        };
    }
}

