/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.stress;

import java.util.Random;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ThreadsDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@Disabled(value="Manual test")
@DisabledOnOs(value={OS.WINDOWS})
public class FileAsyncStressManualTest
extends ContextTestSupport {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        int files = 150;
        for (int i = 0; i < files; ++i) {
            this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)(i + ".txt"));
        }
    }

    @Test
    public void testAsyncStress() throws Exception {
        this.context.getRouteController().startRoute("foo");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(100);
        mock.setResultWaitTime(30000L);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ThreadsDefinition)this.from(FileAsyncStressManualTest.this.fileUri("?maxMessagesPerPoll=50")).routeId("foo").autoStartup(false).threads(10).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Random ran = new Random();
                        int delay = ran.nextInt(50) + 10;
                        Thread.sleep(delay);
                    }
                })).to("mock:result");
            }
        };
    }
}

