/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnCompletionDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Isolated
public class MarkerFileExclusiveReadLockStrategyTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MarkerFileExclusiveReadLockStrategyTest.class);
    private static final int NUMBER_OF_THREADS = 5;
    private final AtomicInteger numberOfFilesProcessed = new AtomicInteger();
    private final CountDownLatch latch = new CountDownLatch(2);

    @Test
    public void testMultithreadedLocking() throws Exception {
        int i;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedFileExists(this.testFile("out/file1.dat"));
        mock.expectedFileExists(this.testFile("out/file2.dat"));
        this.writeFiles();
        this.assertMockEndpointsSatisfied();
        String content = new String(Files.readAllBytes(this.testFile("out/file1.dat")));
        String[] lines = content.split(LS);
        Assertions.assertEquals((int)20, (int)lines.length);
        for (i = 0; i < 20; ++i) {
            Assertions.assertEquals((Object)("Line " + i), (Object)lines[i]);
        }
        content = new String(Files.readAllBytes(this.testFile("out/file2.dat")));
        lines = content.split(LS);
        Assertions.assertEquals((int)20, (int)lines.length);
        for (i = 0; i < 20; ++i) {
            Assertions.assertEquals((Object)("Line " + i), (Object)lines[i]);
        }
        Assertions.assertTrue((boolean)this.latch.await(10L, TimeUnit.SECONDS), (String)"Did not process the messages within 10 seconds");
        MarkerFileExclusiveReadLockStrategyTest.assertFileDoesNotExists(this.testFile("in/file1.dat.camelLock"));
        MarkerFileExclusiveReadLockStrategyTest.assertFileDoesNotExists(this.testFile("in/file2.dat.camelLock"));
        MarkerFileExclusiveReadLockStrategyTest.assertFileDoesNotExists(this.testFile("in/file1.dat"));
        MarkerFileExclusiveReadLockStrategyTest.assertFileDoesNotExists(this.testFile("in/file2.dat"));
        Assertions.assertEquals((int)2, (int)this.numberOfFilesProcessed.get());
    }

    private void writeFiles() throws Exception {
        LOG.debug("Writing files...");
        try (OutputStream fos = Files.newOutputStream(this.testFile("in/file1.dat"), new OpenOption[0]);
             OutputStream fos2 = Files.newOutputStream(this.testFile("in/file2.dat"), new OpenOption[0]);){
            for (int i = 0; i < 20; ++i) {
                fos.write(("Line " + i + LS).getBytes());
                fos2.write(("Line " + i + LS).getBytes());
                LOG.debug("Writing line {}", (Object)i);
            }
            fos.flush();
            fos2.flush();
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnCompletionDefinition)this.from(MarkerFileExclusiveReadLockStrategyTest.this.fileUri("in?readLock=markerFile&initialDelay=0&delay=10")).onCompletion().process(new Processor(){

                    public void process(Exchange exchange) {
                        MarkerFileExclusiveReadLockStrategyTest.this.numberOfFilesProcessed.addAndGet(1);
                        MarkerFileExclusiveReadLockStrategyTest.this.latch.countDown();
                    }
                })).end().threads(5).to(new String[]{MarkerFileExclusiveReadLockStrategyTest.this.fileUri("out"), "mock:result"});
            }
        };
    }

    private static void assertFileDoesNotExists(Path file) {
        Assertions.assertFalse((boolean)Files.exists(file, new LinkOption[0]), (String)("File " + String.valueOf(file) + " should not exist, it should have been deleted after being processed"));
    }
}

