/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.GenericFileDeleteProcessStrategy;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GenericFileDeleteProcessStrategyTest
extends ContextTestSupport {
    private static int existsCounter;
    private static int deleteCounter;

    @Test
    public void testTroubleDeletingFile() throws Exception {
        deleteCounter = 0;
        existsCounter = 0;
        GenericFileEndpoint endpoint = (GenericFileEndpoint)this.context.getEndpoint(this.fileUri(), GenericFileEndpoint.class);
        Exchange exchange = endpoint.createExchange();
        GenericFile file = new GenericFile();
        file.setAbsoluteFilePath(this.testFile("me.txt").toString());
        GenericFileDeleteProcessStrategy strategy = new GenericFileDeleteProcessStrategy();
        strategy.commit((GenericFileOperations)new MyGenericFileOperations(), endpoint, exchange, file);
        Assertions.assertEquals((int)2, (int)deleteCounter, (String)"Should have tried to delete file 2 times");
        Assertions.assertEquals((int)2, (int)existsCounter, (String)"Should have tried to delete file 2 times");
    }

    @Test
    public void testCannotDeleteFile() {
        deleteCounter = 0;
        existsCounter = 0;
        GenericFileEndpoint endpoint = (GenericFileEndpoint)this.context.getEndpoint(this.fileUri(), GenericFileEndpoint.class);
        Exchange exchange = endpoint.createExchange();
        GenericFile file = new GenericFile();
        file.setAbsoluteFilePath(this.testFile("boom.txt").toString());
        GenericFileDeleteProcessStrategy strategy = new GenericFileDeleteProcessStrategy();
        Assertions.assertThrows(GenericFileOperationFailedException.class, () -> strategy.commit((GenericFileOperations)new MyGenericFileOperations(), endpoint, exchange, file), (String)"Should have thrown an exception");
        Assertions.assertEquals((int)3, (int)deleteCounter, (String)"Should have tried to delete file 3 times");
        Assertions.assertEquals((int)3, (int)existsCounter, (String)"Should have tried to delete file 3 times");
    }

    private class MyGenericFileOperations
    implements GenericFileOperations<Object> {
        private MyGenericFileOperations() {
        }

        public GenericFile<Object> newGenericFile() {
            return null;
        }

        public void setEndpoint(GenericFileEndpoint<Object> endpoint) {
        }

        public boolean deleteFile(String name) throws GenericFileOperationFailedException {
            ++deleteCounter;
            return false;
        }

        public boolean existsFile(String name) throws GenericFileOperationFailedException {
            ++existsCounter;
            if (FileUtil.normalizePath((String)GenericFileDeleteProcessStrategyTest.this.testFile("boom.txt").toString()).equals(name)) {
                return true;
            }
            return existsCounter <= 1;
        }

        public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
            return false;
        }

        public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
            return false;
        }

        public boolean retrieveFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
            return false;
        }

        public void releaseRetrievedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
        }

        public boolean storeFile(String name, Exchange exchange, long size) throws GenericFileOperationFailedException {
            return false;
        }

        public String getCurrentDirectory() throws GenericFileOperationFailedException {
            return null;
        }

        public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
        }

        public void changeToParentDirectory() throws GenericFileOperationFailedException {
        }

        public Object[] listFiles() throws GenericFileOperationFailedException {
            return null;
        }

        public Object[] listFiles(String path) throws GenericFileOperationFailedException {
            return null;
        }
    }
}

