/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileIdempotentReadLockDelayedAsyncTest
extends ContextTestSupport {
    final MemoryIdempotentRepository myRepo = new MemoryIdempotentRepository();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myRepo", (Object)this.myRepo);
        return jndi;
    }

    @Test
    public void testIdempotentReadLock() throws Exception {
        Assertions.assertEquals((int)0, (int)this.myRepo.getCacheSize());
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).create();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.message(0).arrives().between(0, 1400).millis();
        mock.message(1).arrives().between(0, 1400).millis();
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)notify.matches(10L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)2, (int)this.myRepo.getCacheSize());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileIdempotentReadLockDelayedAsyncTest.this.fileUri("?initialDelay=0&delay=10&readLock=idempotent&readLockIdempotentReleaseDelay=1000&readLockIdempotentReleaseAsync=true&idempotentRepository=#myRepo")).process(new Processor(){

                    public void process(Exchange exchange) {
                        int size = FileIdempotentReadLockDelayedAsyncTest.this.myRepo.getCacheSize();
                        Assertions.assertTrue((size == 1 || size == 2 ? 1 : 0) != 0);
                    }
                })).to("mock:result");
            }
        };
    }
}

