/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class FileChangedZeroLengthReadLockTest
extends ContextTestSupport {
    @Test
    public void testChangedReadLock() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile("out/zerofile.dat"));
        this.writeZeroLengthFile();
        this.assertMockEndpointsSatisfied();
    }

    private void writeZeroLengthFile() throws Exception {
        Files.write(this.testFile("in/zerofile.dat"), new byte[0], new OpenOption[0]);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileChangedZeroLengthReadLockTest.this.fileUri("in?initialDelay=0&delay=10&readLock=changed&readLockCheckInterval=100&readLockMinLength=0")).to(new String[]{FileChangedZeroLengthReadLockTest.this.fileUri("out"), "mock:result"});
            }
        };
    }
}

