/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class FileChangedReadLockZeroTimeoutTest
extends ContextTestSupport {
    @Test
    @Timeout(value=10L)
    public void testChangedReadLockZeroTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile("out/hello1.txt"));
        this.template.sendBodyAndHeader(this.fileUri("in"), (Object)"Hello World", "CamelFileName", (Object)"hello1.txt");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        this.oneExchangeDone.reset();
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile("out/hello2.txt"));
        this.template.sendBodyAndHeader(this.fileUri("in"), (Object)"Hello Again World", "CamelFileName", (Object)"hello2.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileChangedReadLockZeroTimeoutTest.this.fileUri("in?initialDelay=0&delay=10&readLock=changed&readLockCheckInterval=50&readLockTimeout=0")).to(new String[]{FileChangedReadLockZeroTimeoutTest.this.fileUri("out"), "mock:result"});
            }
        };
    }
}

