/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Isolated(value="Does not play well with parallel unit test execution")
public class FileChangedReadLockTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FileChangedReadLockTest.class);

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.testDirectory("in", true);
        super.setUp();
    }

    @Test
    public void testChangedReadLock() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile("out/slowfile.dat"));
        mock.expectedHeaderReceived("CamelFileLength", (Object)this.expectedFileLength());
        this.writeSlowFile();
        this.assertMockEndpointsSatisfied();
        String content = new String(Files.readAllBytes(this.testFile("out/slowfile.dat")));
        String[] lines = content.split(LS);
        Assertions.assertEquals((int)20, (int)lines.length, (String)"There should be 20 lines in the file");
        for (int i = 0; i < 20; ++i) {
            Assertions.assertEquals((Object)("Line " + i), (Object)lines[i]);
        }
    }

    private void writeSlowFile() throws Exception {
        LOG.debug("Writing slow file...");
        try (OutputStream fos = Files.newOutputStream(this.testFile("in/slowfile.dat"), new OpenOption[0]);){
            for (int i = 0; i < 20; ++i) {
                fos.write(("Line " + i + LS).getBytes());
                LOG.debug("Writing line {}", (Object)i);
                Thread.sleep(50L);
            }
            fos.flush();
        }
        LOG.debug("Writing slow file DONE...");
    }

    long expectedFileLength() {
        long length = 0L;
        for (int i = 0; i < 20; ++i) {
            length += (long)("Line " + i + LS).getBytes().length;
        }
        return length;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileChangedReadLockTest.this.fileUri("in?initialDelay=0&delay=10&readLock=changed&readLockCheckInterval=100")).to(new String[]{FileChangedReadLockTest.this.fileUri("out"), "mock:result"});
            }
        };
    }
}

