/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangedReadLockMinAgeTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FileChangedReadLockMinAgeTest.class);

    @Test
    public void testChangedReadLockMinAge() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile("out/slowfile.dat"));
        mock.expectedMessagesMatches(new Predicate[]{FileChangedReadLockMinAgeTest.exchangeProperty("CamelReceivedTimestamp").convertTo(Long.TYPE).isGreaterThan((Object)(new Date().getTime() + 500L))});
        this.writeSlowFile();
        this.assertMockEndpointsSatisfied();
        String content = new String(Files.readAllBytes(this.testFile("out/slowfile.dat")));
        String[] lines = content.split(LS);
        Assertions.assertEquals((int)20, (int)lines.length, (String)"There should be 20 lines in the file");
        for (int i = 0; i < 20; ++i) {
            Assertions.assertEquals((Object)("Line " + i), (Object)lines[i]);
        }
    }

    private void writeSlowFile() throws Exception {
        LOG.debug("Writing slow file...");
        try (OutputStream fos = Files.newOutputStream(this.testFile("in/slowfile.dat"), new OpenOption[0]);){
            for (int i = 0; i < 20; ++i) {
                fos.write(("Line " + i + LS).getBytes());
                LOG.debug("Writing line {}", (Object)i);
                Thread.sleep(50L);
            }
            fos.flush();
        }
        LOG.debug("Writing slow file DONE...");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileChangedReadLockMinAgeTest.this.fileUri("in?initialDelay=0&delay=10&readLock=changed&readLockCheckInterval=100&readLockMinAge=1000&readLockTimeout=1500")).to(new String[]{FileChangedReadLockMinAgeTest.this.fileUri("out"), "mock:result"});
            }
        };
    }
}

