/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangedReadLockMinAgeShortCircuitTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FileChangedReadLockMinAgeShortCircuitTest.class);

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.testDirectory("in", true);
        LOG.debug("Writing file...");
        Files.write(this.testFile("in/file.dat"), "Line".getBytes(), new OpenOption[0]);
        LOG.debug("Writing file DONE...");
    }

    @Test
    public void testChangedReadLockMinAgeNotAcquired() throws Exception {
        this.context.getShutdownStrategy().setTimeout(1L);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.assertIsSatisfied(2000L);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileChangedReadLockMinAgeShortCircuitTest.this.fileUri("in?initialDelay=500&delay=10&readLock=changed&readLockMinAge=1000&readLockCheckInterval=10000&readLockTimeout=20000")).to(new String[]{FileChangedReadLockMinAgeShortCircuitTest.this.fileUri("out"), "mock:result"});
            }
        };
    }
}

