/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.cluster;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.cluster.FileLockClusterService;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.cluster.ClusteredRoutePolicy;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileLockClusteredRoutePolicyTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockClusteredRoutePolicyTest.class);
    private static final List<String> CLIENTS = List.of("0", "1", "2");
    private static final List<String> RESULTS = new ArrayList<String>();
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(CLIENTS.size());
    private static final CountDownLatch LATCH = new CountDownLatch(CLIENTS.size());
    @TempDir
    private static Path tempDir;

    @Test
    public void test() throws Exception {
        for (String id : CLIENTS) {
            SCHEDULER.submit(() -> FileLockClusteredRoutePolicyTest.run(id));
        }
        LATCH.await(1L, TimeUnit.MINUTES);
        SCHEDULER.shutdownNow();
        Assertions.assertEquals((int)CLIENTS.size(), (int)RESULTS.size());
        Assertions.assertTrue((boolean)RESULTS.containsAll(CLIENTS));
    }

    private static void run(final String id) {
        try {
            int events = ThreadLocalRandom.current().nextInt(2, 6);
            final CountDownLatch contextLatch = new CountDownLatch(events);
            FileLockClusterService service = new FileLockClusterService();
            service.setId("node-" + id);
            service.setRoot(tempDir.toString());
            service.setAcquireLockDelay(1L, TimeUnit.SECONDS);
            service.setAcquireLockInterval(1L, TimeUnit.SECONDS);
            DefaultCamelContext context = new DefaultCamelContext();
            context.disableJMX();
            context.getCamelContextExtension().setName("context-" + id);
            context.addService((Object)service);
            context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("timer:file-lock?delay=1000&period=1000").routeId("route-" + id).routePolicy(new RoutePolicy[]{ClusteredRoutePolicy.forNamespace((String)"my-ns")}).log("From ${routeId}")).process(e -> contextLatch.countDown());
                }
            });
            Awaitility.await().pollDelay((long)ThreadLocalRandom.current().nextInt(500), TimeUnit.MILLISECONDS).untilAsserted(() -> Assertions.assertDoesNotThrow(() -> ((DefaultCamelContext)context).start()));
            context.start();
            contextLatch.await();
            LOGGER.debug("Shutting down node {}", (Object)id);
            RESULTS.add(id);
            context.stop();
            LATCH.countDown();
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

