/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;

public class XPathToFileTest
extends ContextTestSupport {
    @Test
    public void testXPathToFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        String xml = "<foo><person id=\"1\">Claus<country>SE</country></person><person id=\"2\">Jonathan<country>CA</country></person></foo>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        this.template.sendBody("direct:start", (Object)doc);
        this.assertMockEndpointsSatisfied();
        XPathToFileTest.assertFileExists(this.testFile("xpath-0.xml"), "<person id=\"1\">Claus<country>SE</country></person>");
        XPathToFileTest.assertFileExists(this.testFile("xpath-1.xml"), "<person id=\"2\">Jonathan<country>CA</country></person>");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)this.from("direct:start").split((Expression)this.xpath("/foo/person")).log("${bodyAs(String)}")).to(XPathToFileTest.this.fileUri("?fileName=xpath-${exchangeProperty.CamelSplitIndex}.xml"))).to("mock:result");
            }
        };
    }
}

