/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class ToFileRouteTest
extends ContextTestSupport {
    @Test
    public void testToFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile("report.txt"));
        this.template.sendBody("direct:reports", (Object)"This is a great report");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry reg = super.createCamelRegistry();
        reg.bind("processReport", (Object)new ProcessReport());
        return reg;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:reports").process("processReport")).to(new String[]{ToFileRouteTest.this.fileUri(), "mock:result"});
            }
        };
    }

    private static class ProcessReport
    implements Processor {
        private ProcessReport() {
        }

        public void process(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            exchange.getMessage().setBody((Object)body);
            exchange.getMessage().setHeader("CamelFileName", (Object)"report.txt");
        }
    }
}

