/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class NewFileConsumerTest
extends ContextTestSupport {
    private MyFileEndpoint myFile;

    @Test
    public void testNewFileConsumer() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Awaitility.await((String)"postPollCheck invocation").atMost(1L, TimeUnit.SECONDS).until(this.myFile::isPost);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                NewFileConsumerTest.this.myFile = new MyFileEndpoint();
                NewFileConsumerTest.this.myFile.setCamelContext((CamelContext)NewFileConsumerTest.this.context);
                NewFileConsumerTest.this.myFile.setFile(NewFileConsumerTest.this.testDirectory().toFile());
                NewFileConsumerTest.this.myFile.setDelay(10L);
                NewFileConsumerTest.this.myFile.setInitialDelay(0L);
                this.from((Endpoint)NewFileConsumerTest.this.myFile).to("mock:result");
            }
        };
    }

    private static class MyFileEndpoint
    extends FileEndpoint {
        private volatile boolean post;

        private MyFileEndpoint() {
        }

        protected FileConsumer newFileConsumer(Processor processor, GenericFileOperations<File> operations) {
            return new FileConsumer(this, processor, operations, this.createGenericFileStrategy()){

                protected void postPollCheck(int polledMessages) {
                    post = true;
                }
            };
        }

        public boolean isPost() {
            return this.post;
        }
    }
}

