/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.file.FileComponent;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NewFileConsumeTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private final CountDownLatch latch = new CountDownLatch(1);

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testNewFileConsumer() throws Exception {
        FileComponent comp = new FileComponent();
        comp.setCamelContext((CamelContext)this.context);
        Files.createDirectories(this.testDirectory(), new FileAttribute[0]);
        Files.write(this.testFile(TEST_FILE_NAME), "Hello World".getBytes(), new OpenOption[0]);
        GenericFileEndpoint endpoint = comp.createEndpoint(this.fileUri(), this.testDirectory().toString(), new HashMap());
        Consumer consumer = endpoint.createConsumer(exchange -> {
            Assertions.assertNotNull((Object)exchange);
            String body = (String)exchange.getIn().getBody(String.class);
            Assertions.assertEquals((Object)"Hello World", (Object)body);
            this.latch.countDown();
        });
        NewFileConsumeTest.assertFileExists(this.testFile(TEST_FILE_NAME));
        consumer.start();
        this.latch.await(5L, TimeUnit.SECONDS);
        consumer.stop();
        comp.close();
    }
}

