/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MarkerFileExclusiveReadLockStrategyUnlockTest
extends ContextTestSupport {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.testDirectory("input-a", true);
        this.testDirectory("input-b", true);
    }

    @Test
    public void testUnlocking() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).create();
        Files.write(this.testFile("input-a/file1.dat"), "File-1".getBytes(), new OpenOption[0]);
        Files.write(this.testFile("input-b/file2.dat"), "File-2".getBytes(), new OpenOption[0]);
        boolean done = notify.matches(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)done, (String)"Route should be done processing 1 exchanges");
        MarkerFileExclusiveReadLockStrategyUnlockTest.assertFileNotExists(this.testFile("input-a/file1.dat.camelLock"));
        MarkerFileExclusiveReadLockStrategyUnlockTest.assertFileNotExists(this.testFile("input-b/file2.dat.camelLock"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(MarkerFileExclusiveReadLockStrategyUnlockTest.this.fileUri("input-a?fileName=file1.dat&readLock=markerFile&initialDelay=0&delay=10")).pollEnrich(MarkerFileExclusiveReadLockStrategyUnlockTest.this.fileUri("input-b?fileName=file2.dat&readLock=markerFile&initialDelay=0&delay=10"))).to("mock:result");
            }
        };
    }
}

