/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="This test is regularly flaky")
public class MarkerFileExclusiveReadLockStrategyRecursiveCleanupTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.testDirectory("d1/d2/d3/d4/d5", true);
        this.createFiles("d1", "d1.dat");
        this.createFiles("d1/d2", "d2.dat");
        this.createFiles("d1/d2/d3", "d3.dat");
        this.createFiles("d1/d2/d3/d4", "d4.dat");
        this.createFiles("d1/d2/d3/d4/d5", "d5.dat");
    }

    @Test
    public void testNonRecursive() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(MarkerFileExclusiveReadLockStrategyRecursiveCleanupTest.this.fileUri("d1?fileName=d1.dat&readLock=markerFile&readLockDeleteOrphanLockFiles=true&initialDelay=0&delay=10")).to("mock:result");
            }
        });
        this.context.start();
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).create();
        boolean done = notify.matches(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)done, (String)"Route should be done processing 1 exchanges");
        this.checkFilesNotExists("d1", "d1.dat");
        this.checkFilesExists("d1/d2", "d2.dat");
        this.checkFilesExists("d1/d2/d3", "d3.dat");
        this.checkFilesExists("d1/d2/d3/d4", "d4.dat");
        this.checkFilesExists("d1/d2/d3/d4/d5", "d5.dat");
    }

    @Test
    public void testRecursiveSingleDepth() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(MarkerFileExclusiveReadLockStrategyRecursiveCleanupTest.this.fileUri("d1?include=.*.dat&readLock=markerFile&readLockDeleteOrphanLockFiles=true&initialDelay=0&delay=10&recursive=true&minDepth=2&maxDepth=2")).to("mock:result");
            }
        });
        this.context.start();
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).create();
        boolean done = notify.matches(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)done, (String)"Route should be done processing 1 exchanges");
        this.context.stop();
        this.checkFilesExists("d1", "d1.dat");
        this.checkFilesNotExists("d1/d2", "d2.dat");
        this.checkFilesExists("d1/d2/d3", "d3.dat");
        this.checkFilesExists("d1/d2/d3/d4", "d4.dat");
        this.checkFilesExists("d1/d2/d3/d4/d5", "d5.dat");
    }

    @Test
    public void testRecursiveRange() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(MarkerFileExclusiveReadLockStrategyRecursiveCleanupTest.this.fileUri("d1?include=.*.dat&readLock=markerFile&readLockDeleteOrphanLockFiles=true&initialDelay=0&delay=10&recursive=true&minDepth=2&maxDepth=4")).to("mock:result");
            }
        });
        this.context.start();
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(3).create();
        boolean done = notify.matches(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)done, (String)"Route should be done processing 3 exchanges");
        this.context.stop();
        this.checkFilesExists("d1", "d1.dat");
        this.checkFilesNotExists("d1/d2", "d2.dat");
        this.checkFilesNotExists("d1/d2/d3", "d3.dat");
        this.checkFilesNotExists("d1/d2/d3/d4", "d4.dat");
        this.checkFilesExists("d1/d2/d3/d4/d5", "d5.dat");
    }

    @Test
    public void testRecursiveRangeAntInclude() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(MarkerFileExclusiveReadLockStrategyRecursiveCleanupTest.this.fileUri("d1?antInclude=**/*.dat&readLock=markerFile&readLockDeleteOrphanLockFiles=true&initialDelay=0&delay=10&recursive=true&minDepth=2&maxDepth=4")).to("mock:result");
            }
        });
        this.context.start();
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(3).create();
        boolean done = notify.matches(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)done, (String)"Route should be done processing 3 exchanges");
        this.context.stop();
        this.checkFilesExists("d1", "d1.dat");
        this.checkFilesNotExists("d1/d2", "d2.dat");
        this.checkFilesNotExists("d1/d2/d3", "d3.dat");
        this.checkFilesNotExists("d1/d2/d3/d4", "d4.dat");
        this.checkFilesExists("d1/d2/d3/d4/d5", "d5.dat");
    }

    @Test
    public void testRecursive() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(MarkerFileExclusiveReadLockStrategyRecursiveCleanupTest.this.fileUri("d1?include=.*.dat&readLock=markerFile&readLockDeleteOrphanLockFiles=true&initialDelay=0&delay=10&recursive=true")).to("mock:result");
            }
        });
        this.context.start();
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(5).create();
        boolean done = notify.matches(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)done, (String)"Route should be done processing 5 exchanges");
        this.context.stop();
        this.checkFilesNotExists("d1", "d1.dat");
        this.checkFilesNotExists("d1/d2", "d2.dat");
        this.checkFilesNotExists("d1/d2/d3", "d3.dat");
        this.checkFilesNotExists("d1/d2/d3/d4", "d4.dat");
        this.checkFilesNotExists("d1/d2/d3/d4/d5", "d5.dat");
    }

    private void createFiles(String dir, String fileName) throws IOException {
        Files.write(this.testFile(dir + "/" + fileName), fileName.getBytes(), new OpenOption[0]);
        Files.write(this.testFile(dir + "/" + fileName + ".camelLock"), "".getBytes(), new OpenOption[0]);
    }

    private void checkFilesExists(String dir, String fileName) {
        MarkerFileExclusiveReadLockStrategyRecursiveCleanupTest.assertFileExists(this.testFile(dir + "/" + fileName));
        MarkerFileExclusiveReadLockStrategyRecursiveCleanupTest.assertFileExists(this.testFile(dir + "/" + fileName + ".camelLock"));
    }

    private void checkFilesNotExists(String dir, String fileName) {
        MarkerFileExclusiveReadLockStrategyRecursiveCleanupTest.assertFileNotExists(this.testFile(dir + "/" + fileName));
        MarkerFileExclusiveReadLockStrategyRecursiveCleanupTest.assertFileNotExists(this.testFile(dir + "/" + fileName + ".camelLock"));
    }
}

