/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileMessage;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GenericFileMessageTest
extends ContextTestSupport {
    private final CamelContext camelContext = new DefaultCamelContext();

    @Test
    public void testGenericMessageToStringConversion() {
        GenericFileMessage message = new GenericFileMessage(this.camelContext);
        GenericFileMessageTest.assertStringContains(message.toString(), "org.apache.camel.component.file.GenericFileMessage@");
        GenericFile file = new GenericFile(true);
        file.setFileName("target/dummy/test.txt");
        file.setFile((Object)new File("target/dummy/test.txt"));
        message = new GenericFileMessage(this.camelContext, file);
        String o1 = FileUtil.isWindows() ? "target\\dummy\\test.txt" : "target/dummy/test.txt";
        Assertions.assertEquals((Object)o1, (Object)message.toString());
    }

    @Test
    public void testGenericFileContentType() {
        GenericFile file = new GenericFile(true);
        file.setEndpointPath("target");
        file.setFileName("target");
        file.setFile((Object)new File("target/camel-core-test.log"));
        GenericFileMessage message = new GenericFileMessage(this.camelContext, file);
        file.populateHeaders(message, false);
        Assertions.assertEquals((Object)"txt", (Object)message.getHeader("CamelFileContentType"), (String)"Get a wrong file content type");
    }
}

