/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.converter.stream.InputStreamCache;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class GenericFileConverterTest
extends ContextTestSupport {
    public static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testToFile() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(GenericFileConverterTest.this.fileUri("?initialDelay=0&delay=10")).convertBodyTo(File.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(File.class);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testToString() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(GenericFileConverterTest.this.fileUri("?initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(String.class);
        ((MockValueBuilder)mock.message(0).body()).isEqualTo((Object)"Hello World");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testToBytes() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(GenericFileConverterTest.this.fileUri("?initialDelay=0&delay=10")).convertBodyTo(byte[].class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(byte[].class);
        ((MockValueBuilder)mock.message(0).body(String.class)).isEqualTo((Object)"Hello World");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testToSerializable() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(GenericFileConverterTest.this.fileUri("?initialDelay=0&delay=10")).convertBodyTo(Serializable.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(Serializable.class);
        ((MockValueBuilder)mock.message(0).body(String.class)).isEqualTo((Object)"Hello World");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testToInputStream() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(GenericFileConverterTest.this.fileUri("?initialDelay=0&delay=10")).convertBodyTo(InputStream.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(InputStream.class);
        ((MockValueBuilder)mock.message(0).body(String.class)).isEqualTo((Object)"Hello World");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testToFileInputStream() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(GenericFileConverterTest.this.fileUri("?initialDelay=0&delay=10")).convertBodyTo(InputStream.class)).process(new Processor(){

                    public void process(Exchange exchange) {
                        Object body = exchange.getIn().getBody();
                        TestSupport.assertIsInstanceOf(InputStreamCache.class, body);
                    }
                })).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(InputStreamCache.class);
        ((MockValueBuilder)mock.message(0).body(String.class)).isEqualTo((Object)"Hello World");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testToFileInputStreamNoStreamCaching() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(GenericFileConverterTest.this.fileUri("?initialDelay=0&delay=10")).streamCache(Boolean.toString(false)).convertBodyTo(InputStream.class)).process(new Processor(){

                    public void process(Exchange exchange) {
                        Object body = exchange.getIn().getBody();
                        TestSupport.assertIsInstanceOf(BufferedInputStream.class, body);
                    }
                })).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(BufferedInputStream.class);
        ((MockValueBuilder)mock.message(0).body(String.class)).isEqualTo((Object)"Hello World");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }
}

