/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FromFilePollThirdTimeOkTest
extends ContextTestSupport {
    private static int counter;

    @Test
    public void testPollFileAndShouldBeDeletedAtThirdPoll() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(3).create();
        String body = "Hello World this file will be deleted";
        this.template.sendBodyAndHeader(this.fileUri(), (Object)body, "CamelFileName", (Object)"hello.txt");
        this.context.getRouteController().startRoute("FromFilePollThirdTimeOkTest");
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{body});
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)notify.matchesWaitTime());
        Assertions.assertEquals((int)3, (int)counter);
        FromFilePollThirdTimeOkTest.assertFileNotExists(this.testFile("hello.txt"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(FromFilePollThirdTimeOkTest.this.fileUri("?delete=true&initialDelay=0&delay=10")).autoStartup(false).routeId("FromFilePollThirdTimeOkTest").process(new Processor(){

                    public void process(Exchange exchange) {
                        if (++counter < 3) {
                            TestSupport.assertFileExists(FromFilePollThirdTimeOkTest.this.testFile("hello.txt"));
                            throw new IllegalArgumentException("Forced by unittest");
                        }
                    }
                })).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

