/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.PipelineDefinition;
import org.junit.jupiter.api.Test;

public class FromFileMulticastToFilesTest
extends ContextTestSupport {
    @Test
    public void testFromFileMulticastToFiles() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)this.from(FromFileMulticastToFilesTest.this.fileUri("?initialDelay=0&delay=10")).multicast().pipeline().transform((Expression)this.body().prepend((Object)"HEADER:"))).to(FromFileMulticastToFilesTest.this.fileUri("out/?fileName=header.txt"))).to("mock:header")).end().pipeline().transform((Expression)this.body().prepend((Object)"FOOTER:"))).to(FromFileMulticastToFilesTest.this.fileUri("out/?fileName=footer.txt"))).to("mock:footer")).end().end().to("mock:end");
            }
        });
        this.context.start();
        MockEndpoint header = this.getMockEndpoint("mock:header");
        header.expectedBodiesReceived(new Object[]{"HEADER:foo"});
        header.expectedFileExists(this.testFile("out/header.txt"));
        MockEndpoint footer = this.getMockEndpoint("mock:footer");
        footer.expectedBodiesReceived(new Object[]{"FOOTER:foo"});
        footer.expectedFileExists(this.testFile("out/footer.txt"));
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        end.expectedFileExists(this.testFile(".camel/foo.txt"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"foo", "CamelFileName", (Object)"foo.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFromFileMulticastParallelToFiles() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)this.from(FromFileMulticastToFilesTest.this.fileUri("?initialDelay=0&delay=10")).multicast().parallelProcessing().pipeline().transform((Expression)this.body().prepend((Object)"HEADER:"))).to(FromFileMulticastToFilesTest.this.fileUri("out/?fileName=header.txt"))).to("mock:header")).end().pipeline().transform((Expression)this.body().prepend((Object)"FOOTER:"))).to(FromFileMulticastToFilesTest.this.fileUri("out/?fileName=footer.txt"))).to("mock:footer")).end().end().to("mock:end");
            }
        });
        this.context.start();
        MockEndpoint header = this.getMockEndpoint("mock:header");
        header.expectedBodiesReceived(new Object[]{"HEADER:foo"});
        header.expectedFileExists(this.testFile("out/header.txt"));
        MockEndpoint footer = this.getMockEndpoint("mock:footer");
        footer.expectedBodiesReceived(new Object[]{"FOOTER:foo"});
        footer.expectedFileExists(this.testFile("out/footer.txt"));
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        end.expectedFileExists(this.testFile(".camel/foo.txt"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"foo", "CamelFileName", (Object)"foo.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

