/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FromFileMoveFileIfProcessFailsTest
extends ContextTestSupport {
    @Test
    public void testPollFileAndShouldNotBeMoved() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedFileExists(this.testFile("error/hello.txt"), "Hello World");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(FromFileMoveFileIfProcessFailsTest.this.fileUri("?initialDelay=0&delay=10&moveFailed=error")).convertBodyTo(String.class)).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new IllegalArgumentException("Forced by unittest");
                    }
                });
            }
        };
    }
}

