/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FromFileMoveDoneCustomHeaderTest
extends ContextTestSupport {
    @Test
    public void testMoveDoneCustomHeader() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.testFile("outbox/hello.txt"));
        mock.expectedFileExists(this.testFile("inbox/dones/mydone.txt"));
        this.template.sendBodyAndHeader(this.fileUri("inbox"), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(FromFileMoveDoneCustomHeaderTest.this.fileUri("inbox?initialDelay=0&delay=10&move=${header.bar}")).setHeader("bar", (Expression)this.constant("dones/mydone.txt"))).transform((Expression)this.constant("Bye World"))).to(new String[]{"mock:result", FromFileMoveDoneCustomHeaderTest.this.fileUri("outbox")});
            }
        };
    }
}

