/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class FromFileDoNotMoveFileIfProcessFailsTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testPollFileAndShouldNotBeMoved() throws Exception {
        String body = "Hello World this file will NOT be moved";
        this.template.sendBodyAndHeader(this.fileUri(), (Object)body, "CamelFileName", (Object)TEST_FILE_NAME);
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedMinimumMessageCount(1);
        mock.assertIsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        FromFileDoNotMoveFileIfProcessFailsTest.assertFileExists(this.testFile(TEST_FILE_NAME));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).to("mock:error");
                this.from(FromFileDoNotMoveFileIfProcessFailsTest.this.fileUri("?initialDelay=0&delay=10&move=done")).process(new Processor(){

                    public void process(Exchange exchange) {
                        throw new IllegalArgumentException("Forced by unittest");
                    }
                });
            }
        };
    }
}

