/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FilerProducerFileNamesTest
extends ContextTestSupport {
    @Test
    public void testProducerWithMessageIdAsFileName() {
        Endpoint endpoint = this.context.getEndpoint("direct:report");
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setBody((Object)"This is a good report");
        FileEndpoint fileEndpoint = this.resolveMandatoryEndpoint(this.fileUri("reports/report.txt"), FileEndpoint.class);
        String id = fileEndpoint.getGeneratedFileName(exchange.getIn());
        this.template.send("direct:report", exchange);
        FilerProducerFileNamesTest.assertFileExists(this.testFile("reports/" + id));
    }

    @Test
    public void testProducerWithHeaderFileName() {
        this.template.sendBody("direct:report2", (Object)"This is super good report");
        FilerProducerFileNamesTest.assertFileExists(this.testFile("report-super.txt"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:report").to(FilerProducerFileNamesTest.this.fileUri("reports"));
                ((RouteDefinition)this.from("direct:report2").setHeader("CamelFileName", (Expression)this.constant("report-super.txt"))).to(FilerProducerFileNamesTest.this.fileUri());
            }
        };
    }
}

