/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Properties;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilerProducerDoneFileNameTest
extends ContextTestSupport {
    public static final String TEST_FILE_NAME_NOEXT = "hello." + String.valueOf(UUID.randomUUID());
    public static final String TEST_FILE_NAME = TEST_FILE_NAME_NOEXT + ".txt";
    private final Properties myProp = new Properties();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myProp", (Object)this.myProp);
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("ref:myProp");
        return context;
    }

    @Test
    public void testProducerConstantDoneFileName() {
        String doneFileName = "xdone" + String.valueOf(UUID.randomUUID());
        this.template.sendBodyAndHeader(this.fileUri("?doneFileName=" + doneFileName), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        FilerProducerDoneFileNameTest.assertFileExists(this.testFile(TEST_FILE_NAME));
        FilerProducerDoneFileNameTest.assertFileExists(this.testFile(doneFileName));
    }

    @Test
    public void testProducerPrefixDoneFileName() {
        this.template.sendBodyAndHeader(this.fileUri("?doneFileName=done-${file:name}"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        FilerProducerDoneFileNameTest.assertFileExists(this.testFile(TEST_FILE_NAME));
        FilerProducerDoneFileNameTest.assertFileExists(this.testFile("done-" + TEST_FILE_NAME));
    }

    @Test
    public void testProducerExtDoneFileName() {
        this.template.sendBodyAndHeader(this.fileUri("?doneFileName=${file:name}.done"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        FilerProducerDoneFileNameTest.assertFileExists(this.testFile(TEST_FILE_NAME));
        FilerProducerDoneFileNameTest.assertFileExists(this.testFile(TEST_FILE_NAME + ".done"));
    }

    @Test
    public void testProducerReplaceExtDoneFileName() {
        this.template.sendBodyAndHeader(this.fileUri("?doneFileName=${file:name.noext}.done"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        FilerProducerDoneFileNameTest.assertFileExists(this.testFile(TEST_FILE_NAME));
        FilerProducerDoneFileNameTest.assertFileExists(this.testFile(TEST_FILE_NAME_NOEXT + ".done"));
    }

    @Test
    public void testProducerInvalidDoneFileName() {
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader(this.fileUri("?doneFileName=${file:parent}/foo"), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME));
        ExpressionIllegalSyntaxException cause = FilerProducerDoneFileNameTest.assertIsInstanceOf(ExpressionIllegalSyntaxException.class, e.getCause());
        Assertions.assertTrue((boolean)cause.getMessage().endsWith("Cannot resolve reminder: ${file:parent}/foo"), (String)cause.getMessage());
    }

    @Test
    public void testProducerEmptyDoneFileName() {
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBodyAndHeader(this.fileUri("?doneFileName="), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME));
        IllegalArgumentException cause = FilerProducerDoneFileNameTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertTrue((boolean)cause.getMessage().startsWith("doneFileName must be specified and not empty"), (String)cause.getMessage());
    }

    @Test
    public void testProducerPlaceholderPrefixDoneFileName() {
        this.myProp.put("myDir", this.testDirectory().toString());
        this.template.sendBodyAndHeader("file:{{myDir}}?doneFileName=done-${file:name}", (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        FilerProducerDoneFileNameTest.assertFileExists(this.testFile(TEST_FILE_NAME));
        FilerProducerDoneFileNameTest.assertFileExists(this.testFile("done-" + TEST_FILE_NAME));
    }
}

