/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilerProducerDoneFileNameRouteTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private final Properties myProp = new Properties();

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myProp", (Object)this.myProp);
        return jndi;
    }

    @Test
    public void testProducerPlaceholderPrefixDoneFileName() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.oneExchangeDone.matches(5L, TimeUnit.SECONDS));
        FilerProducerDoneFileNameRouteTest.assertFileExists(this.testFile(TEST_FILE_NAME));
        FilerProducerDoneFileNameRouteTest.assertFileExists(this.testFile("done-" + TEST_FILE_NAME));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                FilerProducerDoneFileNameRouteTest.this.myProp.put("myDir", FilerProducerDoneFileNameRouteTest.this.testDirectory().toString());
                FilerProducerDoneFileNameRouteTest.this.context.getPropertiesComponent().setLocation("ref:myProp");
                ((RouteDefinition)this.from("direct:start").to("file:{{myDir}}?doneFileName=done-${file:name}")).to("mock:result");
            }
        };
    }
}

