/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class FilerProducerAbsoluteTest
extends ContextTestSupport {
    private String path;

    @Test
    public void testProduceAbsoluteFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists(this.path + "/hello.txt");
        this.template.sendBodyAndHeader("direct:report", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        this.path = this.testDirectory("absolute").toAbsolutePath().toString();
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:report").to(new String[]{"file://" + FilerProducerAbsoluteTest.this.path, "mock:result"});
            }
        };
    }
}

