/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class FilerConsumerShouldSkipDoneFileTest
extends ContextTestSupport {
    @Test
    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"", "CamelFileName", (Object)"done");
        Awaitility.await().pollDelay(250L, TimeUnit.MILLISECONDS).untilAsserted(() -> this.assertMockEndpointsSatisfied());
        this.resetMocks();
        this.oneExchangeDone.reset();
        FilerConsumerShouldSkipDoneFileTest.assertFileExists(this.testFile("done"));
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        FilerConsumerShouldSkipDoneFileTest.assertFileNotExists(this.testFile("done"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FilerConsumerShouldSkipDoneFileTest.this.fileUri("?doneFileName=done&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

