/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class FilerConsumerShouldSkipDoneFileSuffixTest
extends ContextTestSupport {
    @Test
    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"", "CamelFileName", (Object)"hello.txt.ready");
        Awaitility.await().pollDelay(100L, TimeUnit.MILLISECONDS).untilAsserted(() -> this.assertMockEndpointsSatisfied());
        this.resetMocks();
        this.oneExchangeDone.reset();
        FilerConsumerShouldSkipDoneFileSuffixTest.assertFileExists(this.testFile("hello.txt.ready"));
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        FilerConsumerShouldSkipDoneFileSuffixTest.assertFileNotExists(this.testFile("hello.txt.ready"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FilerConsumerShouldSkipDoneFileSuffixTest.this.fileUri("?doneFileName=${file:name}.ready&initialDelay=0&delay=50")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

