/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FilerConsumerRetryDoneFileNameTest
extends ContextTestSupport {
    @Test
    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:input").expectedMessageCount(2);
        this.getMockEndpoint("mock:input").expectedFileExists(this.testFile(".camel/hello.txt"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"", "CamelFileName", (Object)"done");
        this.assertMockEndpointsSatisfied();
        FilerConsumerRetryDoneFileNameTest.assertFileNotExists(this.testFile("done"));
        FilerConsumerRetryDoneFileNameTest.assertFileExists(this.testFile(".camel/hello.txt"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FilerConsumerRetryDoneFileNameTest.this.fileUri("?doneFileName=done&initialDelay=0&delay=10")).to("mock:input")).process(new Processor(){
                    int index;

                    public void process(Exchange exchange) {
                        if (this.index++ == 0) {
                            TestSupport.assertFileExists(FilerConsumerRetryDoneFileNameTest.this.testFile("done"));
                            throw new IllegalArgumentException("Forced");
                        }
                    }
                });
            }
        };
    }
}

